/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.widgets;

import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.swing.JTextField;
import javax.swing.text.JTextComponent;
import org.openstreetmap.josm.data.osm.OsmPrimitiveType;
import org.openstreetmap.josm.data.osm.PrimitiveId;
import org.openstreetmap.josm.data.osm.SimplePrimitiveId;
import org.openstreetmap.josm.gui.widgets.AbstractTextComponentValidator;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OsmIdTextField
extends JTextField {
    private OsmIdValidator validator = OsmIdValidator.decorate(this);

    public void setType(OsmPrimitiveType osmPrimitiveType) {
        this.validator.type = osmPrimitiveType;
    }

    public List<PrimitiveId> getIds() {
        return this.validator.ids;
    }

    public boolean readOsmIds() {
        return this.validator.readOsmIds();
    }

    public void performValidation() {
        this.validator.validate();
    }

    public void clearTextIfInvalid() {
        if (!this.validator.isValid()) {
            this.setText("");
        }
        this.validator.validate();
    }

    private static class OsmIdValidator
    extends AbstractTextComponentValidator {
        private List<PrimitiveId> ids = new ArrayList<PrimitiveId>();
        private OsmPrimitiveType type;

        public static OsmIdValidator decorate(JTextComponent jTextComponent) {
            return new OsmIdValidator(jTextComponent);
        }

        public OsmIdValidator(JTextComponent jTextComponent) {
            super(jTextComponent, false);
        }

        public boolean isValid() {
            return this.readOsmIds();
        }

        public void validate() {
            if (!this.isValid()) {
                this.feedbackInvalid(I18n.tr("The current value is not a valid OSM ID. Please enter an integer value > 0", new Object[0]));
            } else {
                this.feedbackValid(I18n.tr("Please enter an integer value > 0", new Object[0]));
            }
        }

        public boolean readOsmIds() {
            String string = this.getComponent().getText();
            if (string == null || string.trim().length() == 0) {
                return false;
            }
            this.ids.clear();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",.+/ \t\n");
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                char c = string2.charAt(0);
                if (c == 'v') continue;
                try {
                    this.ids.add(SimplePrimitiveId.fromString(string2));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    try {
                        if (this.type == OsmPrimitiveType.NODE) {
                            this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.NODE));
                            continue;
                        }
                        if (this.type == OsmPrimitiveType.WAY) {
                            this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.WAY));
                            continue;
                        }
                        if (this.type == OsmPrimitiveType.RELATION) {
                            this.ids.add(new SimplePrimitiveId(Long.parseLong(string2), OsmPrimitiveType.RELATION));
                            continue;
                        }
                        return false;
                    }
                    catch (IllegalArgumentException illegalArgumentException2) {
                        return false;
                    }
                }
            }
            return true;
        }
    }
}

