/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.ButtonGroup;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.data.projection.UTM;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UTMProjectionChoice
extends ListProjectionChoice
implements Alias {
    private static final UTM.Hemisphere DEFAULT_HEMISPHERE = UTM.Hemisphere.North;
    private UTM.Hemisphere hemisphere;
    private static final List<String> cbEntries = new ArrayList<String>();

    public UTMProjectionChoice() {
        super("core:utm", I18n.tr("UTM", new Object[0]), cbEntries.toArray(), I18n.tr("UTM Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new UTMPanel(this.entries, this.index, this.label, actionListener);
    }

    @Override
    public Projection getProjection() {
        return new UTM(this.index + 1, this.hemisphere);
    }

    @Override
    public Collection<String> getPreferences(JPanel jPanel) {
        UTMPanel uTMPanel = (UTMPanel)jPanel;
        int n = uTMPanel.prefcb.getSelectedIndex();
        UTM.Hemisphere hemisphere = uTMPanel.south.isSelected() ? UTM.Hemisphere.South : UTM.Hemisphere.North;
        return Arrays.asList(this.indexToZone(n), hemisphere.toString());
    }

    @Override
    public String[] allCodes() {
        ArrayList<String> arrayList = new ArrayList<String>(240);
        for (int i = 1; i <= 60; ++i) {
            for (UTM.Hemisphere hemisphere : UTM.Hemisphere.values()) {
                arrayList.add("EPSG:" + (32600 + i + (hemisphere == UTM.Hemisphere.South ? 100 : 0)));
            }
        }
        return arrayList.toArray(new String[0]);
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:326") || string.startsWith("EPSG:327")) {
            try {
                UTM.Hemisphere hemisphere = string.charAt(7) == '6' ? UTM.Hemisphere.North : UTM.Hemisphere.South;
                String string2 = string.substring(8);
                int n = Integer.parseInt(string2);
                if (n > 0 && n <= 60) {
                    return Arrays.asList(string2, hemisphere.toString());
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    public void setPreferences(Collection<String> collection) {
        String[] stringArray;
        super.setPreferences(collection);
        UTM.Hemisphere hemisphere = DEFAULT_HEMISPHERE;
        if (collection != null && (stringArray = collection.toArray(new String[0])).length > 1) {
            hemisphere = UTM.Hemisphere.valueOf(stringArray[1]);
        }
        this.hemisphere = hemisphere;
    }

    @Override
    protected String indexToZone(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    protected int zoneToIndex(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultIndex;
        }
    }

    @Override
    public String getAlias() {
        return UTM.class.getName();
    }

    static {
        for (int i = 1; i <= 60; ++i) {
            cbEntries.add(Integer.toString(i));
        }
    }

    private class UTMPanel
    extends ListProjectionChoice.CBPanel {
        public JRadioButton north;
        public JRadioButton south;

        public UTMPanel(Object[] objectArray, int n, String string, ActionListener actionListener) {
            super(objectArray, n, string, actionListener);
            this.north = new JRadioButton();
            this.north.setSelected(UTMProjectionChoice.this.hemisphere == UTM.Hemisphere.North);
            this.south = new JRadioButton();
            this.south.setSelected(UTMProjectionChoice.this.hemisphere == UTM.Hemisphere.South);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.north);
            buttonGroup.add(this.south);
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new GridBagLayout());
            jPanel.add((Component)new JLabel(I18n.tr("North", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            jPanel.add((Component)this.north, GBC.std().fill(2));
            jPanel.add(GBC.glue(1, 0), GBC.std().fill(2));
            jPanel.add((Component)new JLabel(I18n.tr("South", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            jPanel.add((Component)this.south, GBC.std().fill(2));
            jPanel.add(GBC.glue(1, 1), GBC.eol().fill(1));
            this.add((Component)new JLabel(I18n.tr("Hemisphere", new Object[0])), GBC.std().insets(5, 5, 0, 5));
            this.add(GBC.glue(1, 0), GBC.std().fill(2));
            this.add((Component)jPanel, GBC.eop().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
            if (actionListener != null) {
                this.north.addActionListener(actionListener);
                this.south.addActionListener(actionListener);
            }
        }
    }
}

