/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.openstreetmap.josm.data.projection.LambertCC9Zones;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LambertCC9ZonesProjectionChoice
extends ListProjectionChoice
implements Alias {
    private static String[] lambert9zones = new String[]{I18n.tr("{0} ({1} to {2} degrees)", 1, 41, 43), I18n.tr("{0} ({1} to {2} degrees)", 2, 42, 44), I18n.tr("{0} ({1} to {2} degrees)", 3, 43, 45), I18n.tr("{0} ({1} to {2} degrees)", 4, 44, 46), I18n.tr("{0} ({1} to {2} degrees)", 5, 45, 47), I18n.tr("{0} ({1} to {2} degrees)", 6, 46, 48), I18n.tr("{0} ({1} to {2} degrees)", 7, 47, 49), I18n.tr("{0} ({1} to {2} degrees)", 8, 48, 50), I18n.tr("{0} ({1} to {2} degrees)", 9, 49, 51)};

    public LambertCC9ZonesProjectionChoice() {
        super("core:lambertcc9", I18n.tr("Lambert CC9 Zone (France)", new Object[0]), lambert9zones, I18n.tr("Lambert CC Zone", new Object[0]));
    }

    @Override
    public JPanel getPreferencePanel(ActionListener actionListener) {
        return new LambertCC9CBPanel(this.entries, this.index, this.label, actionListener);
    }

    @Override
    public Projection getProjection() {
        return new LambertCC9Zones(this.index);
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[9];
        for (int i = 0; i < 9; ++i) {
            stringArray[i] = "EPSG:" + (3942 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        if (string.startsWith("EPSG:39") && string.length() == 9) {
            try {
                String string2 = string.substring(5, 9);
                int n = Integer.parseInt(string2) - 3942;
                if (n >= 0 && n <= 8) {
                    return Collections.singleton(String.valueOf(n + 1));
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return null;
    }

    @Override
    protected String indexToZone(int n) {
        return Integer.toString(n + 1);
    }

    @Override
    protected int zoneToIndex(String string) {
        try {
            return Integer.parseInt(string) - 1;
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultIndex;
        }
    }

    @Override
    public String getAlias() {
        return LambertCC9Zones.class.getName();
    }

    private class LambertCC9CBPanel
    extends ListProjectionChoice.CBPanel {
        public LambertCC9CBPanel(Object[] objectArray, int n, String string, ActionListener actionListener) {
            super(objectArray, n, string, actionListener);
            this.add((Component)new JLabel(ImageProvider.get("data/projection", "LambertCC9Zones.png")), GBC.eol().fill(2));
            this.add(GBC.glue(1, 1), GBC.eol().fill(1));
        }
    }
}

