/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences.projection;

import java.util.Collection;
import java.util.Collections;
import org.openstreetmap.josm.data.projection.GaussKrueger;
import org.openstreetmap.josm.data.projection.Projection;
import org.openstreetmap.josm.gui.preferences.projection.Alias;
import org.openstreetmap.josm.gui.preferences.projection.ListProjectionChoice;
import org.openstreetmap.josm.tools.I18n;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GaussKruegerProjectionChoice
extends ListProjectionChoice
implements Alias {
    private static String[] zones = new String[]{"2", "3", "4", "5"};

    public GaussKruegerProjectionChoice() {
        super("core:gauss-krueger", I18n.tr("Gau\u00df-Kr\u00fcger", new Object[0]), zones, I18n.tr("GK Zone", new Object[0]));
    }

    @Override
    public Projection getProjection() {
        return new GaussKrueger(this.index + 2);
    }

    @Override
    protected String indexToZone(int n) {
        return Integer.toString(n + 2);
    }

    @Override
    protected int zoneToIndex(String string) {
        try {
            return Integer.parseInt(string) - 2;
        }
        catch (NumberFormatException numberFormatException) {
            return this.defaultIndex;
        }
    }

    @Override
    public String[] allCodes() {
        String[] stringArray = new String[4];
        for (int i = 2; i <= 5; ++i) {
            stringArray[i - 2] = "EPSG:" + (31464 + i);
        }
        return stringArray;
    }

    @Override
    public Collection<String> getPreferencesFromCode(String string) {
        for (int i = 2; i <= 5; ++i) {
            String string2 = "EPSG:" + (31464 + i);
            if (!string2.equals(string)) continue;
            return Collections.singleton(String.valueOf(i));
        }
        return null;
    }

    @Override
    public String getAlias() {
        return GaussKrueger.class.getName();
    }
}

