/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.preferences;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EventObject;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListCellRenderer;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.HelpAwareOptionPane;
import org.openstreetmap.josm.gui.PleaseWaitRunnable;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.preferences.SourceEntry;
import org.openstreetmap.josm.gui.preferences.SourceProvider;
import org.openstreetmap.josm.gui.widgets.JFileChooserManager;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.OsmTransferException;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.LanguageInfo;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SourceEditor
extends JPanel {
    protected final boolean isMapPaint;
    protected final JTable tblActiveSources;
    protected final ActiveSourcesModel activeSourcesModel;
    protected final JList lstAvailableSources;
    protected final AvailableSourcesListModel availableSourcesModel;
    protected final JTable tblIconPaths;
    protected final IconPathTableModel iconPathsModel;
    protected final String availableSourcesUrl;
    protected final List<SourceProvider> sourceProviders;
    protected boolean sourcesInitiallyLoaded;

    public SourceEditor(final boolean bl, String string, List<SourceProvider> list) {
        this.isMapPaint = bl;
        DefaultListSelectionModel defaultListSelectionModel = new DefaultListSelectionModel();
        this.availableSourcesModel = new AvailableSourcesListModel(defaultListSelectionModel);
        this.lstAvailableSources = new JList(this.availableSourcesModel);
        this.lstAvailableSources.setSelectionModel(defaultListSelectionModel);
        this.lstAvailableSources.setCellRenderer(new SourceEntryListCellRenderer());
        this.availableSourcesUrl = string;
        this.sourceProviders = list;
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.activeSourcesModel = new ActiveSourcesModel(defaultListSelectionModel);
        this.tblActiveSources = new JTable(this.activeSourcesModel){

            public void scrollRectToVisible(Rectangle rectangle) {
                super.scrollRectToVisible(new Rectangle(0, rectangle.y, rectangle.width, rectangle.height));
            }
        };
        this.tblActiveSources.putClientProperty("terminateEditOnFocusLost", true);
        this.tblActiveSources.setSelectionModel(defaultListSelectionModel);
        this.tblActiveSources.setSelectionMode(2);
        this.tblActiveSources.setShowGrid(false);
        this.tblActiveSources.setIntercellSpacing(new Dimension(0, 0));
        this.tblActiveSources.setTableHeader(null);
        this.tblActiveSources.setAutoResizeMode(0);
        SourceEntryTableCellRenderer sourceEntryTableCellRenderer = new SourceEntryTableCellRenderer();
        if (bl) {
            this.tblActiveSources.getColumnModel().getColumn(0).setMaxWidth(1);
            this.tblActiveSources.getColumnModel().getColumn(0).setResizable(false);
            this.tblActiveSources.getColumnModel().getColumn(1).setCellRenderer(sourceEntryTableCellRenderer);
        } else {
            this.tblActiveSources.getColumnModel().getColumn(0).setCellRenderer(sourceEntryTableCellRenderer);
        }
        this.activeSourcesModel.addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent tableModelEvent) {
                SourceEditor.adjustColumnWidth(SourceEditor.this.tblActiveSources, bl ? 1 : 0);
            }
        });
        this.activeSourcesModel.setActiveSources(this.getInitialSourcesList());
        final EditActiveSourceAction editActiveSourceAction = new EditActiveSourceAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(editActiveSourceAction);
        this.tblActiveSources.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (mouseEvent.getClickCount() == 2) {
                    int n = SourceEditor.this.tblActiveSources.rowAtPoint(mouseEvent.getPoint());
                    int n2 = SourceEditor.this.tblActiveSources.columnAtPoint(mouseEvent.getPoint());
                    if (n < 0 || n >= SourceEditor.this.tblActiveSources.getRowCount()) {
                        return;
                    }
                    if (bl && n2 != 1) {
                        return;
                    }
                    editActiveSourceAction.actionPerformed(null);
                }
            }
        });
        RemoveActiveSourcesAction removeActiveSourcesAction = new RemoveActiveSourcesAction();
        this.tblActiveSources.getSelectionModel().addListSelectionListener(removeActiveSourcesAction);
        this.tblActiveSources.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblActiveSources.getActionMap().put("delete", removeActiveSourcesAction);
        MoveUpDownAction moveUpDownAction = null;
        MoveUpDownAction moveUpDownAction2 = null;
        if (bl) {
            moveUpDownAction = new MoveUpDownAction(false);
            moveUpDownAction2 = new MoveUpDownAction(true);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUpDownAction);
            this.tblActiveSources.getSelectionModel().addListSelectionListener(moveUpDownAction2);
            this.activeSourcesModel.addTableModelListener(moveUpDownAction);
            this.activeSourcesModel.addTableModelListener(moveUpDownAction2);
        }
        ActivateSourcesAction activateSourcesAction = new ActivateSourcesAction();
        this.lstAvailableSources.addListSelectionListener(activateSourcesAction);
        JButton jButton = new JButton(activateSourcesAction);
        this.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 11, 0, 0);
        this.add((Component)new JLabel(this.getStr(I18nString.AVAILABLE_SOURCES)), gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.insets = new Insets(5, 0, 0, 6);
        this.add((Component)new JLabel(this.getStr(I18nString.ACTIVE_SOURCES)), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.8;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        JScrollPane jScrollPane = new JScrollPane(this.lstAvailableSources);
        this.add((Component)jScrollPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.setBorderPainted(false);
        jToolBar.setOpaque(false);
        jToolBar.add(Box.createHorizontalGlue());
        jToolBar.add(jButton);
        jToolBar.add(Box.createHorizontalGlue());
        this.add((Component)jToolBar, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.tblActiveSources);
        this.add((Component)jScrollPane2, gridBagConstraints);
        jScrollPane2.setColumnHeaderView(null);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        JToolBar jToolBar2 = new JToolBar(1);
        jToolBar2.setFloatable(false);
        jToolBar2.setBorderPainted(false);
        jToolBar2.setOpaque(false);
        jToolBar2.add(new NewActiveSourceAction());
        jToolBar2.add(editActiveSourceAction);
        jToolBar2.add(removeActiveSourcesAction);
        jToolBar2.addSeparator(new Dimension(12, 30));
        if (bl) {
            jToolBar2.add(moveUpDownAction);
            jToolBar2.add(moveUpDownAction2);
        }
        this.add((Component)jToolBar2, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        JToolBar jToolBar3 = new JToolBar();
        jToolBar3.setFloatable(false);
        jToolBar3.setBorderPainted(false);
        jToolBar3.setOpaque(false);
        jToolBar3.add(new ReloadSourcesAction(string, list));
        jToolBar3.add(Box.createHorizontalGlue());
        this.add((Component)jToolBar3, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JToolBar jToolBar4 = new JToolBar();
        jToolBar4.setFloatable(false);
        jToolBar4.setBorderPainted(false);
        jToolBar4.setOpaque(false);
        jToolBar4.add(Box.createHorizontalGlue());
        jToolBar4.add(new JButton(new ResetAction()));
        this.add((Component)jToolBar4, gridBagConstraints);
        defaultListSelectionModel = new DefaultListSelectionModel();
        this.iconPathsModel = new IconPathTableModel(defaultListSelectionModel);
        this.tblIconPaths = new JTable(this.iconPathsModel);
        this.tblIconPaths.setSelectionModel(defaultListSelectionModel);
        this.tblIconPaths.setSelectionMode(2);
        this.tblIconPaths.setTableHeader(null);
        this.tblIconPaths.getColumnModel().getColumn(0).setCellEditor(new FileOrUrlCellEditor(false));
        this.tblIconPaths.setRowHeight(20);
        this.tblIconPaths.putClientProperty("terminateEditOnFocusLost", true);
        this.iconPathsModel.setIconPaths(this.getInitialIconPathsList());
        EditIconPathAction editIconPathAction = new EditIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(editIconPathAction);
        RemoveIconPathAction removeIconPathAction = new RemoveIconPathAction();
        this.tblIconPaths.getSelectionModel().addListSelectionListener(removeIconPathAction);
        this.tblIconPaths.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), "delete");
        this.tblIconPaths.getActionMap().put("delete", removeIconPathAction);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.insets = new Insets(8, 11, 8, 6);
        this.add((Component)new JSeparator(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(0, 11, 0, 6);
        this.add((Component)new JLabel(I18n.tr("Icon paths:", new Object[0])), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.2;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 11, 0, 0);
        jScrollPane2 = new JScrollPane(this.tblIconPaths);
        this.add((Component)jScrollPane2, gridBagConstraints);
        jScrollPane2.setColumnHeaderView(null);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.insets = new Insets(0, 0, 0, 6);
        JToolBar jToolBar5 = new JToolBar(1);
        jToolBar5.setFloatable(false);
        jToolBar5.setBorderPainted(false);
        jToolBar5.setOpaque(false);
        jToolBar5.add(new NewIconPathAction());
        jToolBar5.add(editIconPathAction);
        jToolBar5.add(removeIconPathAction);
        this.add((Component)jToolBar5, gridBagConstraints);
    }

    public abstract Collection<? extends SourceEntry> getInitialSourcesList();

    public abstract Collection<String> getInitialIconPathsList();

    public abstract Collection<ExtendedSourceEntry> getDefault();

    public abstract boolean finish();

    protected abstract String getStr(I18nString var1);

    private static void adjustColumnWidth(JTable jTable, int n) {
        int n2 = 0;
        for (int i = 0; i < jTable.getRowCount(); ++i) {
            TableCellRenderer tableCellRenderer = jTable.getCellRenderer(i, n);
            Object object = jTable.getValueAt(i, n);
            Component component = tableCellRenderer.getTableCellRendererComponent(jTable, object, false, false, i, n);
            n2 = Math.max(component.getPreferredSize().width, n2);
        }
        jTable.getColumnModel().getColumn(n).setPreferredWidth(n2);
    }

    public boolean hasActiveSourcesChanged() {
        Collection<? extends SourceEntry> collection = this.getInitialSourcesList();
        List<SourceEntry> list = this.activeSourcesModel.getSources();
        if (collection.size() != list.size()) {
            return true;
        }
        Iterator<? extends SourceEntry> iterator = collection.iterator();
        Iterator<SourceEntry> iterator2 = list.iterator();
        while (iterator.hasNext()) {
            SourceEntry sourceEntry = iterator.next();
            SourceEntry sourceEntry2 = iterator2.next();
            if (Utils.equal(sourceEntry.url, sourceEntry2.url) && Utils.equal(sourceEntry.name, sourceEntry2.name) && sourceEntry.active == sourceEntry2.active) continue;
            return true;
        }
        return false;
    }

    public Collection<SourceEntry> getActiveSources() {
        return this.activeSourcesModel.getSources();
    }

    public void removeSources(Collection<Integer> collection) {
        this.activeSourcesModel.removeIdxs(collection);
    }

    protected void reloadAvailableSources(String string, List<SourceProvider> list) {
        Main.worker.submit(new SourceLoader(string, list));
    }

    public void initiallyLoadAvailableSources() {
        if (!this.sourcesInitiallyLoaded) {
            this.reloadAvailableSources(this.availableSourcesUrl, this.sourceProviders);
        }
        this.sourcesInitiallyLoaded = true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class SourcePrefHelper {
        private final String prefOld;
        private final String pref;

        public SourcePrefHelper(String string, String string2) {
            this.pref = string;
            this.prefOld = string2;
        }

        public abstract Collection<ExtendedSourceEntry> getDefault();

        public abstract Map<String, String> serialize(SourceEntry var1);

        public abstract SourceEntry deserialize(Map<String, String> var1);

        public abstract Map<String, String> migrate(Collection<String> var1);

        public List<SourceEntry> get() {
            Collection<Collection<String>> collection;
            boolean bl = false;
            Collection<Map<String, String>> collection2 = Main.pref.getListOfStructs(this.pref, (Collection<Map<String, String>>)null);
            if (collection2 == null && (collection = Main.pref.getArray(this.prefOld, null)) != null) {
                bl = true;
                collection2 = new ArrayList<Map<String, String>>();
                for (Collection map : collection) {
                    collection2.add(this.migrate(map));
                }
            }
            if (collection2 == null) {
                return new ArrayList<SourceEntry>(this.getDefault());
            }
            collection = new ArrayList<Collection<String>>();
            for (Map<String, String> map : collection2) {
                SourceEntry sourceEntry = this.deserialize(new HashMap<String, String>(map));
                if (sourceEntry == null) continue;
                collection.add((Collection<String>)((Object)sourceEntry));
            }
            if (bl) {
                this.put(collection);
            }
            return collection;
        }

        public boolean put(Collection<? extends SourceEntry> collection) {
            ArrayList<Map<String, String>> arrayList = new ArrayList<Map<String, String>>();
            for (SourceEntry sourceEntry : collection) {
                arrayList.add(this.serialize(sourceEntry));
            }
            return Main.pref.putListOfStructs(this.pref, arrayList);
        }
    }

    class FileOrUrlCellEditor
    extends JPanel
    implements TableCellEditor {
        private JTextField tfFileName;
        private CopyOnWriteArrayList<CellEditorListener> listeners;
        private String value;
        private boolean isFile;

        protected void build() {
            this.setLayout(new GridBagLayout());
            GridBagConstraints gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.tfFileName = new JTextField();
            this.add((Component)this.tfFileName, gridBagConstraints);
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.fill = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            this.add(new JButton(new LaunchFileChooserAction()));
            this.tfFileName.addFocusListener(new FocusAdapter(){

                public void focusGained(FocusEvent focusEvent) {
                    FileOrUrlCellEditor.this.tfFileName.selectAll();
                }
            });
        }

        public FileOrUrlCellEditor(boolean bl) {
            this.isFile = bl;
            this.listeners = new CopyOnWriteArrayList();
            this.build();
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
            if (cellEditorListener != null) {
                this.listeners.addIfAbsent(cellEditorListener);
            }
        }

        protected void fireEditingCanceled() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingCanceled(new ChangeEvent(this));
            }
        }

        protected void fireEditingStopped() {
            for (CellEditorListener cellEditorListener : this.listeners) {
                cellEditorListener.editingStopped(new ChangeEvent(this));
            }
        }

        public void cancelCellEditing() {
            this.fireEditingCanceled();
        }

        public Object getCellEditorValue() {
            return this.value;
        }

        public boolean isCellEditable(EventObject eventObject) {
            if (eventObject instanceof MouseEvent) {
                return ((MouseEvent)eventObject).getClickCount() >= 2;
            }
            return true;
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
            this.listeners.remove(cellEditorListener);
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return true;
        }

        public boolean stopCellEditing() {
            this.value = this.tfFileName.getText();
            this.fireEditingStopped();
            return true;
        }

        public void setInitialValue(String string) {
            this.value = string;
            if (string == null) {
                this.tfFileName.setText("");
            } else {
                this.tfFileName.setText(string);
            }
        }

        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.setInitialValue((String)object);
            this.tfFileName.selectAll();
            return this;
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("Name", "...");
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            protected void prepareFileChooser(String string, JFileChooser jFileChooser) {
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    return;
                }
                if (uRL.getProtocol().startsWith("file")) {
                    File file = new File(uRL.getPath());
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooserManager jFileChooserManager = new JFileChooserManager(true).createFileChooser();
                if (!FileOrUrlCellEditor.this.isFile) {
                    jFileChooserManager.getFileChooser().setFileSelectionMode(1);
                }
                this.prepareFileChooser(FileOrUrlCellEditor.this.tfFileName.getText(), jFileChooserManager.getFileChooser());
                JFileChooser jFileChooser = jFileChooserManager.openFileChooser(JOptionPane.getFrameForComponent(SourceEditor.this));
                if (jFileChooser != null) {
                    FileOrUrlCellEditor.this.tfFileName.setText(jFileChooser.getSelectedFile().toString());
                }
            }
        }
    }

    static class SourceEntryTableCellRenderer
    extends DefaultTableCellRenderer {
        SourceEntryTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (object == null) {
                return this;
            }
            SourceEntry sourceEntry = (SourceEntry)object;
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, this.fromSourceEntry(sourceEntry), bl, bl2, n, n2);
            return jLabel;
        }

        private String fromSourceEntry(SourceEntry sourceEntry) {
            if (sourceEntry == null) {
                return null;
            }
            StringBuilder stringBuilder = new StringBuilder("<html><b>");
            if (sourceEntry.title != null) {
                stringBuilder.append(sourceEntry.title).append("</b> <span color=\"gray\">");
            }
            stringBuilder.append(sourceEntry.url);
            if (sourceEntry.title != null) {
                stringBuilder.append("</span>");
            }
            stringBuilder.append("</html>");
            return stringBuilder.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class SourceLoader
    extends PleaseWaitRunnable {
        private final String url;
        private final List<SourceProvider> sourceProviders;
        private BufferedReader reader;
        private boolean canceled;
        private final List<ExtendedSourceEntry> sources;

        public SourceLoader(String string, List<SourceProvider> list) {
            super(I18n.tr(SourceEditor.this.getStr(I18nString.LOADING_SOURCES_FROM), string));
            this.sources = new ArrayList<ExtendedSourceEntry>();
            this.url = string;
            this.sourceProviders = list;
        }

        @Override
        protected void cancel() {
            this.canceled = true;
            if (this.reader != null) {
                try {
                    this.reader.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        protected void warn(Exception exception) {
            String string = exception.getMessage() != null ? exception.getMessage() : exception.toString();
            string = string.replaceAll("&", "&amp;").replaceAll("<", "&lt;").replaceAll(">", "&gt;");
            String string2 = I18n.tr(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM), this.url, string);
            HelpAwareOptionPane.showOptionDialog(Main.parent, string2, I18n.tr("Error", new Object[0]), 0, HelpUtil.ht(SourceEditor.this.getStr(I18nString.FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void realRun() throws SAXException, IOException, OsmTransferException {
            String string = LanguageInfo.getLanguageCodeXML();
            try {
                void var3_7;
                SourceEntry sourceEntry;
                Object object;
                this.sources.addAll(SourceEditor.this.getDefault());
                for (SourceProvider object22 : this.sourceProviders) {
                    object = object22.getSources().iterator();
                    while (object.hasNext()) {
                        sourceEntry = object.next();
                        if (!(sourceEntry instanceof ExtendedSourceEntry)) continue;
                        this.sources.add((ExtendedSourceEntry)sourceEntry);
                    }
                }
                MirroredInputStream mirroredInputStream = new MirroredInputStream(this.url);
                try {
                    InputStreamReader osmTransferException = new InputStreamReader((InputStream)mirroredInputStream, "UTF-8");
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    InputStreamReader inputStreamReader = new InputStreamReader(mirroredInputStream);
                }
                this.reader = new BufferedReader((Reader)var3_7);
                sourceEntry = null;
                while ((object = this.reader.readLine()) != null && !this.canceled) {
                    Matcher matcher;
                    if (((String)object).trim().equals("")) continue;
                    if (((String)object).startsWith("\t")) {
                        matcher = Pattern.compile("^\t([^:]+): *(.+)$").matcher((CharSequence)object);
                        if (!matcher.matches()) {
                            System.err.println(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, object));
                            continue;
                        }
                        if (sourceEntry == null) continue;
                        String string2 = matcher.group(1);
                        String string3 = matcher.group(2);
                        if ("author".equals(string2) && ((ExtendedSourceEntry)sourceEntry).author == null) {
                            ((ExtendedSourceEntry)sourceEntry).author = string3;
                            continue;
                        }
                        if ("version".equals(string2)) {
                            ((ExtendedSourceEntry)sourceEntry).version = string3;
                            continue;
                        }
                        if ("link".equals(string2) && ((ExtendedSourceEntry)sourceEntry).link == null) {
                            ((ExtendedSourceEntry)sourceEntry).link = string3;
                            continue;
                        }
                        if ("description".equals(string2) && ((ExtendedSourceEntry)sourceEntry).description == null) {
                            ((ExtendedSourceEntry)sourceEntry).description = string3;
                            continue;
                        }
                        if ((string + "shortdescription").equals(string2) && ((ExtendedSourceEntry)sourceEntry).title == null) {
                            ((ExtendedSourceEntry)sourceEntry).title = string3;
                            continue;
                        }
                        if ("shortdescription".equals(string2) && ((ExtendedSourceEntry)sourceEntry).title == null) {
                            ((ExtendedSourceEntry)sourceEntry).title = string3;
                            continue;
                        }
                        if ((string + "title").equals(string2) && ((ExtendedSourceEntry)sourceEntry).title == null) {
                            ((ExtendedSourceEntry)sourceEntry).title = string3;
                            continue;
                        }
                        if ("title".equals(string2) && ((ExtendedSourceEntry)sourceEntry).title == null) {
                            ((ExtendedSourceEntry)sourceEntry).title = string3;
                            continue;
                        }
                        if ("name".equals(string2) && ((ExtendedSourceEntry)sourceEntry).name == null) {
                            ((ExtendedSourceEntry)sourceEntry).name = string3;
                            continue;
                        }
                        if ((string + "author").equals(string2)) {
                            ((ExtendedSourceEntry)sourceEntry).author = string3;
                            continue;
                        }
                        if ((string + "link").equals(string2)) {
                            ((ExtendedSourceEntry)sourceEntry).link = string3;
                            continue;
                        }
                        if (!(string + "description").equals(string2)) continue;
                        ((ExtendedSourceEntry)sourceEntry).description = string3;
                        continue;
                    }
                    sourceEntry = null;
                    matcher = Pattern.compile("^(.+);(.+)$").matcher((CharSequence)object);
                    if (matcher.matches()) {
                        sourceEntry = new ExtendedSourceEntry(matcher.group(1), matcher.group(2));
                        this.sources.add((ExtendedSourceEntry)sourceEntry);
                        continue;
                    }
                    System.err.println(I18n.tr(SourceEditor.this.getStr(I18nString.ILLEGAL_FORMAT_OF_ENTRY), this.url, object));
                }
            }
            catch (Exception exception) {
                if (this.canceled) {
                    return;
                }
                OsmTransferException osmTransferException = new OsmTransferException(exception);
                osmTransferException.setUrl(this.url);
                this.warn(osmTransferException);
                return;
            }
        }

        @Override
        protected void finish() {
            Collections.sort(this.sources);
            SourceEditor.this.availableSourcesModel.setSources(this.sources);
        }
    }

    static class SourceEntryListCellRenderer
    extends JLabel
    implements ListCellRenderer {
        SourceEntryListCellRenderer() {
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            String string = object.toString();
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            this.setEnabled(jList.isEnabled());
            this.setFont(jList.getFont());
            this.setFont(this.getFont().deriveFont(0));
            this.setOpaque(true);
            this.setToolTipText(((ExtendedSourceEntry)object).getTooltip());
            return this;
        }
    }

    class EditIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditIconPathAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Edit the selected icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SourceEditor.this.tblIconPaths.getSelectedRow();
            SourceEditor.this.tblIconPaths.editCellAt(n, 0);
        }
    }

    class RemoveIconPathAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveIconPathAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Remove the selected icon paths", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblIconPaths.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.iconPathsModel.removeSelected();
        }
    }

    class NewIconPathAction
    extends AbstractAction {
        public NewIconPathAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Add a new icon path", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.iconPathsModel.addPath("");
            SourceEditor.this.tblIconPaths.editCellAt(SourceEditor.this.iconPathsModel.getRowCount() - 1, 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class IconPathTableModel
    extends AbstractTableModel {
        private ArrayList<String> data;
        private DefaultListSelectionModel selectionModel;

        public IconPathTableModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return true;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.updatePath(n, (String)object);
        }

        public void setIconPaths(Collection<String> collection) {
            this.data.clear();
            if (collection != null) {
                this.data.addAll(collection);
            }
            this.sort();
            this.fireTableDataChanged();
        }

        public void addPath(String string) {
            if (string == null) {
                return;
            }
            this.data.add(string);
            this.sort();
            this.fireTableDataChanged();
            int n = this.data.indexOf(string);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void updatePath(int n, String string) {
            if (string == null) {
                return;
            }
            if (n < 0 || n >= this.getRowCount()) {
                return;
            }
            this.data.set(n, string);
            this.sort();
            this.fireTableDataChanged();
            int n2 = this.data.indexOf(string);
            if (n2 >= 0) {
                this.selectionModel.setSelectionInterval(n2, n2);
            }
        }

        public void removeSelected() {
            Iterator<String> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
        }

        protected void sort() {
            Collections.sort(this.data, new Comparator<String>(){

                @Override
                public int compare(String string, String string2) {
                    if (string.equals("") && string2.equals("")) {
                        return 0;
                    }
                    if (string.equals("")) {
                        return 1;
                    }
                    if (string2.equals("")) {
                        return -1;
                    }
                    return string.compareTo(string2);
                }
            });
        }

        public List<String> getIconPaths() {
            return new ArrayList<String>(this.data);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ReloadSourcesAction
    extends AbstractAction {
        private final String url;
        private final List<SourceProvider> sourceProviders;

        public ReloadSourcesAction(String string, List<SourceProvider> list) {
            this.putValue("Name", I18n.tr("Reload", new Object[0]));
            this.putValue("ShortDescription", I18n.tr(SourceEditor.this.getStr(I18nString.RELOAD_ALL_AVAILABLE), string));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "refresh"));
            this.url = string;
            this.sourceProviders = list;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            MirroredInputStream.cleanup(this.url);
            SourceEditor.this.reloadAvailableSources(this.url, this.sourceProviders);
        }
    }

    class ResetAction
    extends AbstractAction {
        public ResetAction() {
            this.putValue("Name", I18n.tr("Reset", new Object[0]));
            this.putValue("ShortDescription", I18n.tr("Reset to default", new Object[0]));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "reset"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.setActiveSources(SourceEditor.this.getDefault());
        }
    }

    class ActivateSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        public ActivateSourcesAction() {
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.ACTIVATE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("preferences", "activate-right"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(SourceEditor.this.lstAvailableSources.getSelectedIndices().length > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            List<ExtendedSourceEntry> list = SourceEditor.this.availableSourcesModel.getSelected();
            SourceEditor.this.activeSourcesModel.addExtendedSourceEntries(list);
        }
    }

    class MoveUpDownAction
    extends AbstractAction
    implements ListSelectionListener,
    TableModelListener {
        final int increment;

        public MoveUpDownAction(boolean bl) {
            this.increment = bl ? 1 : -1;
            this.putValue("SmallIcon", bl ? ImageProvider.get("dialogs", "down") : ImageProvider.get("dialogs", "up"));
            this.putValue("ShortDescription", bl ? I18n.tr("Move the selected entry one row down.", new Object[0]) : I18n.tr("Move the selected entry one row up.", new Object[0]));
            this.updateEnabledState();
        }

        public void updateEnabledState() {
            this.setEnabled(SourceEditor.this.activeSourcesModel.canMove(this.increment));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.move(this.increment);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.updateEnabledState();
        }
    }

    class EditActiveSourceAction
    extends AbstractAction
    implements ListSelectionListener {
        public EditActiveSourceAction() {
            this.putValue("Name", I18n.tr("Edit", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.EDIT_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "edit"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() == 1);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = SourceEditor.this.tblActiveSources.getSelectedRow();
            if (n < 0 || n >= SourceEditor.this.tblActiveSources.getRowCount()) {
                return;
            }
            SourceEntry sourceEntry = (SourceEntry)SourceEditor.this.activeSourcesModel.getValueAt(n, 1);
            EditSourceEntryDialog editSourceEntryDialog = new EditSourceEntryDialog(SourceEditor.this, I18n.tr("Edit source entry:", new Object[0]), sourceEntry);
            editSourceEntryDialog.showDialog();
            if (editSourceEntryDialog.getValue() == 1) {
                if (sourceEntry.title != null || !Utils.equal(editSourceEntryDialog.getTitle(), "")) {
                    sourceEntry.title = editSourceEntryDialog.getTitle();
                    if (Utils.equal(sourceEntry.title, "")) {
                        sourceEntry.title = null;
                    }
                }
                sourceEntry.url = editSourceEntryDialog.getURL();
                if (SourceEditor.this.isMapPaint) {
                    sourceEntry.active = editSourceEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.fireTableRowsUpdated(n, n);
            }
        }
    }

    class RemoveActiveSourcesAction
    extends AbstractAction
    implements ListSelectionListener {
        public RemoveActiveSourcesAction() {
            this.putValue("Name", I18n.tr("Remove", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.REMOVE_SOURCE_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "delete"));
            this.updateEnabledState();
        }

        protected void updateEnabledState() {
            this.setEnabled(SourceEditor.this.tblActiveSources.getSelectedRowCount() > 0);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            this.updateEnabledState();
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SourceEditor.this.activeSourcesModel.removeSelected();
        }
    }

    class NewActiveSourceAction
    extends AbstractAction {
        public NewActiveSourceAction() {
            this.putValue("Name", I18n.tr("New", new Object[0]));
            this.putValue("ShortDescription", SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY_TOOLTIP));
            this.putValue("SmallIcon", ImageProvider.get("dialogs", "add"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            EditSourceEntryDialog editSourceEntryDialog = new EditSourceEntryDialog(SourceEditor.this, SourceEditor.this.getStr(I18nString.NEW_SOURCE_ENTRY), null);
            editSourceEntryDialog.showDialog();
            if (editSourceEntryDialog.getValue() == 1) {
                boolean bl = true;
                if (SourceEditor.this.isMapPaint) {
                    bl = editSourceEntryDialog.active();
                }
                SourceEditor.this.activeSourcesModel.addSource(new SourceEntry(editSourceEntryDialog.getURL(), null, editSourceEntryDialog.getTitle(), bl));
                SourceEditor.this.activeSourcesModel.fireTableDataChanged();
            }
        }
    }

    protected class EditSourceEntryDialog
    extends ExtendedDialog {
        private JTextField tfTitle;
        private JTextField tfURL;
        private JCheckBox cbActive;

        public EditSourceEntryDialog(Component component, String string, SourceEntry sourceEntry) {
            super(component, string, new String[]{I18n.tr("Ok", new Object[0]), I18n.tr("Cancel", new Object[0])});
            JPanel jPanel = new JPanel(new GridBagLayout());
            this.tfTitle = new JTextField(60);
            jPanel.add((Component)new JLabel(I18n.tr("Name (optional):", new Object[0])), GBC.std().insets(15, 0, 5, 5));
            jPanel.add((Component)this.tfTitle, GBC.eol().insets(0, 0, 5, 5));
            this.tfURL = new JTextField(60);
            jPanel.add((Component)new JLabel(I18n.tr("URL / File:", new Object[0])), GBC.std().insets(15, 0, 5, 0));
            jPanel.add((Component)this.tfURL, GBC.std().insets(0, 0, 5, 5));
            JButton jButton = new JButton(new LaunchFileChooserAction());
            jButton.setMargin(new Insets(0, 0, 0, 0));
            jPanel.add((Component)jButton, GBC.eol().insets(0, 0, 5, 5));
            if (sourceEntry != null) {
                if (sourceEntry.title != null) {
                    this.tfTitle.setText(sourceEntry.title);
                }
                this.tfURL.setText(sourceEntry.url);
            }
            if (SourceEditor.this.isMapPaint) {
                this.cbActive = new JCheckBox(I18n.tr("active", new Object[0]), sourceEntry != null ? sourceEntry.active : true);
                jPanel.add((Component)this.cbActive, GBC.eol().insets(15, 0, 5, 0));
            }
            this.setButtonIcons(new String[]{"ok", "cancel"});
            this.setContent(jPanel);
        }

        public String getTitle() {
            return this.tfTitle.getText();
        }

        public String getURL() {
            return this.tfURL.getText();
        }

        public boolean active() {
            if (!SourceEditor.this.isMapPaint) {
                throw new UnsupportedOperationException();
            }
            return this.cbActive.isSelected();
        }

        class LaunchFileChooserAction
        extends AbstractAction {
            public LaunchFileChooserAction() {
                this.putValue("SmallIcon", ImageProvider.get("open"));
                this.putValue("ShortDescription", I18n.tr("Launch a file chooser to select a file", new Object[0]));
            }

            protected void prepareFileChooser(String string, JFileChooser jFileChooser) {
                if (string == null || string.trim().length() == 0) {
                    return;
                }
                URL uRL = null;
                try {
                    uRL = new URL(string);
                }
                catch (MalformedURLException malformedURLException) {
                    File file = new File(string);
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                    return;
                }
                if (uRL.getProtocol().startsWith("file")) {
                    File file = new File(uRL.getPath());
                    if (file.isFile()) {
                        file = file.getParentFile();
                    }
                    if (file != null) {
                        jFileChooser.setCurrentDirectory(file);
                    }
                }
            }

            public void actionPerformed(ActionEvent actionEvent) {
                JFileChooserManager jFileChooserManager = new JFileChooserManager(true);
                this.prepareFileChooser(EditSourceEntryDialog.this.tfURL.getText(), jFileChooserManager.getFileChooser());
                JFileChooser jFileChooser = jFileChooserManager.openFileChooser(JOptionPane.getFrameForComponent(SourceEditor.this));
                if (jFileChooser != null) {
                    EditSourceEntryDialog.this.tfURL.setText(jFileChooser.getSelectedFile().toString());
                }
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class ExtendedSourceEntry
    extends SourceEntry
    implements Comparable<ExtendedSourceEntry> {
        public String simpleFileName;
        public String version;
        public String author;
        public String link;
        public String description;

        public ExtendedSourceEntry(String string, String string2) {
            super(string2, null, null, true);
            this.simpleFileName = string;
            this.title = null;
            this.description = null;
            this.link = null;
            this.author = null;
            this.version = null;
        }

        public String getDisplayName() {
            return this.title == null ? this.simpleFileName : this.title;
        }

        private void appendRow(StringBuilder stringBuilder, String string, String string2) {
            stringBuilder.append("<tr><th>").append(string).append("</th><td>").append(string2).append("</td</tr>");
        }

        public String getTooltip() {
            StringBuilder stringBuilder = new StringBuilder();
            this.appendRow(stringBuilder, I18n.tr("Short Description:", new Object[0]), this.getDisplayName());
            this.appendRow(stringBuilder, I18n.tr("URL:", new Object[0]), this.url);
            if (this.author != null) {
                this.appendRow(stringBuilder, I18n.tr("Author:", new Object[0]), this.author);
            }
            if (this.link != null) {
                this.appendRow(stringBuilder, I18n.tr("Webpage:", new Object[0]), this.link);
            }
            if (this.description != null) {
                this.appendRow(stringBuilder, I18n.tr("Description:", new Object[0]), this.description);
            }
            if (this.version != null) {
                this.appendRow(stringBuilder, I18n.tr("Version:", new Object[0]), this.version);
            }
            return "<html><style>th{text-align:right}td{width:400px}</style><table>" + stringBuilder + "</table></html>";
        }

        @Override
        public String toString() {
            return "<html><b>" + this.getDisplayName() + "</b>" + (this.author == null ? "" : " <span color=\"gray\">" + I18n.tr("by {0}", this.author) + "</color>") + "</html>";
        }

        @Override
        public int compareTo(ExtendedSourceEntry extendedSourceEntry) {
            if (this.url.startsWith("resource") && !extendedSourceEntry.url.startsWith("resource")) {
                return -1;
            }
            if (extendedSourceEntry.url.startsWith("resource")) {
                return 1;
            }
            return this.getDisplayName().compareToIgnoreCase(extendedSourceEntry.getDisplayName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class ActiveSourcesModel
    extends AbstractTableModel {
        private List<SourceEntry> data;
        private DefaultListSelectionModel selectionModel;

        public ActiveSourcesModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
            this.data = new ArrayList<SourceEntry>();
        }

        @Override
        public int getColumnCount() {
            return SourceEditor.this.isMapPaint ? 2 : 1;
        }

        @Override
        public int getRowCount() {
            return this.data == null ? 0 : this.data.size();
        }

        @Override
        public Object getValueAt(int n, int n2) {
            if (SourceEditor.this.isMapPaint && n2 == 0) {
                return this.data.get((int)n).active;
            }
            return this.data.get(n);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return SourceEditor.this.isMapPaint && n2 == 0;
        }

        @Override
        public Class<?> getColumnClass(int n) {
            if (SourceEditor.this.isMapPaint && n == 0) {
                return Boolean.class;
            }
            return SourceEntry.class;
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            if (n < 0 || n >= this.getRowCount() || object == null) {
                return;
            }
            if (SourceEditor.this.isMapPaint && n2 == 0) {
                this.data.get((int)n).active = !this.data.get((int)n).active;
            }
        }

        public void setActiveSources(Collection<? extends SourceEntry> collection) {
            this.data.clear();
            if (collection != null) {
                for (SourceEntry sourceEntry : collection) {
                    this.data.add(new SourceEntry(sourceEntry));
                }
            }
            this.fireTableDataChanged();
        }

        public void addSource(SourceEntry sourceEntry) {
            if (sourceEntry == null) {
                return;
            }
            this.data.add(sourceEntry);
            this.fireTableDataChanged();
            int n = this.data.indexOf(sourceEntry);
            if (n >= 0) {
                this.selectionModel.setSelectionInterval(n, n);
            }
        }

        public void removeSelected() {
            Iterator<SourceEntry> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireTableDataChanged();
        }

        public void removeIdxs(Collection<Integer> collection) {
            ArrayList<SourceEntry> arrayList = new ArrayList<SourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (collection.contains(i)) continue;
                arrayList.add(this.data.get(i));
            }
            this.data = arrayList;
            this.fireTableDataChanged();
        }

        public void addExtendedSourceEntries(List<ExtendedSourceEntry> list) {
            if (list == null) {
                return;
            }
            for (ExtendedSourceEntry extendedSourceEntry : list) {
                this.data.add(new SourceEntry(extendedSourceEntry.url, extendedSourceEntry.name, extendedSourceEntry.getDisplayName(), true));
            }
            this.fireTableDataChanged();
            this.selectionModel.clearSelection();
            for (ExtendedSourceEntry extendedSourceEntry : list) {
                int n = this.data.indexOf(extendedSourceEntry);
                if (n < 0) continue;
                this.selectionModel.addSelectionInterval(n, n);
            }
        }

        public List<SourceEntry> getSources() {
            return new ArrayList<SourceEntry>(this.data);
        }

        public boolean canMove(int n) {
            int[] nArray = SourceEditor.this.tblActiveSources.getSelectedRows();
            if (nArray.length == 0) {
                return false;
            }
            if (n < 0) {
                return nArray[0] >= -n;
            }
            if (n > 0) {
                return nArray[nArray.length - 1] <= this.getRowCount() - 1 - n;
            }
            return true;
        }

        public void move(int n) {
            int[] nArray;
            if (!this.canMove(n)) {
                return;
            }
            for (int n2 : nArray = SourceEditor.this.tblActiveSources.getSelectedRows()) {
                SourceEntry sourceEntry = this.data.get(n2);
                SourceEntry sourceEntry2 = this.data.get(n2 + n);
                this.data.set(n2, sourceEntry2);
                this.data.set(n2 + n, sourceEntry);
            }
            this.selectionModel.clearSelection();
            for (int n2 : nArray) {
                this.selectionModel.addSelectionInterval(n2 + n, n2 + n);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected static class AvailableSourcesListModel
    extends DefaultListModel {
        private ArrayList<ExtendedSourceEntry> data = new ArrayList();
        private DefaultListSelectionModel selectionModel;

        public AvailableSourcesListModel(DefaultListSelectionModel defaultListSelectionModel) {
            this.selectionModel = defaultListSelectionModel;
        }

        public void setSources(List<ExtendedSourceEntry> list) {
            this.data.clear();
            if (list != null) {
                this.data.addAll(list);
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        @Override
        public Object getElementAt(int n) {
            return this.data.get(n);
        }

        @Override
        public int getSize() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        public void deleteSelected() {
            Iterator<ExtendedSourceEntry> iterator = this.data.iterator();
            int n = 0;
            while (iterator.hasNext()) {
                iterator.next();
                if (this.selectionModel.isSelectedIndex(n)) {
                    iterator.remove();
                }
                ++n;
            }
            this.fireContentsChanged(this, 0, this.data.size());
        }

        public List<ExtendedSourceEntry> getSelected() {
            ArrayList<ExtendedSourceEntry> arrayList = new ArrayList<ExtendedSourceEntry>();
            for (int i = 0; i < this.data.size(); ++i) {
                if (!this.selectionModel.isSelectedIndex(i)) continue;
                arrayList.add(this.data.get(i));
            }
            return arrayList;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum I18nString {
        AVAILABLE_SOURCES,
        ACTIVE_SOURCES,
        NEW_SOURCE_ENTRY_TOOLTIP,
        NEW_SOURCE_ENTRY,
        REMOVE_SOURCE_TOOLTIP,
        EDIT_SOURCE_TOOLTIP,
        ACTIVATE_TOOLTIP,
        RELOAD_ALL_AVAILABLE,
        LOADING_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM,
        FAILED_TO_LOAD_SOURCES_FROM_HELP_TOPIC,
        ILLEGAL_FORMAT_OF_ENTRY;

    }
}

