/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.dialogs;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Graphics;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.data.preferences.ParametrizedEnumProperty;
import org.openstreetmap.josm.gui.MainMenu;
import org.openstreetmap.josm.gui.ShowHideButtonListener;
import org.openstreetmap.josm.gui.SideButton;
import org.openstreetmap.josm.gui.dialogs.DialogsPanel;
import org.openstreetmap.josm.gui.help.HelpUtil;
import org.openstreetmap.josm.gui.help.Helpful;
import org.openstreetmap.josm.tools.Destroyable;
import org.openstreetmap.josm.tools.GBC;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.ImageProvider;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.WindowGeometry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ToggleDialog
extends JPanel
implements ShowHideButtonListener,
Helpful,
AWTEventListener {
    private final ParametrizedEnumProperty<ButtonHiddingType> PROP_BUTTON_HIDING = new ParametrizedEnumProperty<ButtonHiddingType>(ButtonHiddingType.class, ButtonHiddingType.DYNAMIC){

        @Override
        protected String getKey(String ... stringArray) {
            return ToggleDialog.this.preferencePrefix + ".buttonhiding";
        }

        @Override
        protected ButtonHiddingType parse(String string) {
            try {
                return (ButtonHiddingType)((Object)super.parse(string));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                return Boolean.parseBoolean(string) ? ButtonHiddingType.DYNAMIC : ButtonHiddingType.ALWAYS_HIDDEN;
            }
        }
    };
    protected ToggleDialogAction toggleAction;
    protected String preferencePrefix;
    protected final String name;
    protected DialogsPanel dialogsPanel;
    protected TitleBar titleBar;
    protected boolean isShowing;
    protected boolean isDocked;
    protected boolean isCollapsed;
    protected ButtonHiddingType buttonHiding;
    private int preferredHeight;
    private JLabel lblMinimized;
    private JButton buttonsHide = null;
    protected JDialog detachedDialog;
    protected JToggleButton button;
    private JPanel buttonsPanel;
    private List<Action> buttonActions = new ArrayList<Action>();
    protected JCheckBoxMenuItem windowMenuItem;

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n) {
        this(string, string2, string3, shortcut, n, false);
    }

    public ToggleDialog(String string, String string2, String string3, Shortcut shortcut, int n, boolean bl) {
        super(new BorderLayout());
        this.preferencePrefix = string2;
        this.name = string;
        this.setPreferredSize(new Dimension(0, n));
        this.setMinimumSize(new Dimension(0, 0));
        this.preferredHeight = n;
        this.toggleAction = new ToggleDialogAction(string, "dialogs/" + string2, string3, shortcut, string2);
        String string4 = "Dialog/" + this.getClass().getName().substring(this.getClass().getName().lastIndexOf(46) + 1);
        this.toggleAction.putValue("help", string4.substring(0, string4.length() - 6));
        this.isShowing = Main.pref.getBoolean(this.preferencePrefix + ".visible", bl);
        this.isDocked = Main.pref.getBoolean(this.preferencePrefix + ".docked", true);
        this.isCollapsed = Main.pref.getBoolean(this.preferencePrefix + ".minimized", false);
        this.buttonHiding = this.PROP_BUTTON_HIDING.get(new String[0]);
        this.titleBar = new TitleBar(string, string2);
        this.add((Component)this.titleBar, "North");
        this.setBorder(BorderFactory.createEtchedBorder());
        Main.redirectToMainContentPane(this);
        this.windowMenuItem = MainMenu.addWithCheckbox(Main.main.menu.windowMenu, (JosmAction)this.getToggleAction(), MainMenu.WINDOW_MENU_GROUP.TOGGLE_DIALOG);
    }

    public void showDialog() {
        this.setIsShowing(true);
        if (!this.isDocked) {
            this.detach();
        } else {
            this.dock();
            this.setVisible(true);
        }
        this.setIsShowing(true);
        this.windowMenuItem.setState(true);
        this.toggleAction.putValue("selected", false);
        this.toggleAction.putValue("selected", true);
    }

    public void unfurlDialog() {
        if (this.isDialogInDefaultView()) {
            return;
        }
        if (this.isDialogInCollapsedView()) {
            this.expand();
            this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, this);
        } else if (!this.isDialogShowing()) {
            this.showDialog();
            if (this.isDocked && this.isCollapsed) {
                this.expand();
            }
            if (this.isDocked) {
                this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, this);
            }
            this.showNotify();
        }
    }

    @Override
    public void buttonHidden() {
        if (((Boolean)this.toggleAction.getValue("selected")).booleanValue()) {
            this.toggleAction.actionPerformed(null);
        }
    }

    @Override
    public void buttonShown() {
        this.unfurlDialog();
    }

    public void hideDialog() {
        this.closeDetachedDialog();
        this.setVisible(false);
        this.windowMenuItem.setState(false);
        this.setIsShowing(false);
        this.toggleAction.putValue("selected", false);
    }

    protected void dock() {
        this.detachedDialog = null;
        this.titleBar.setVisible(true);
        this.setIsDocked(true);
    }

    protected void detach() {
        this.setContentVisible(true);
        this.setVisible(true);
        this.titleBar.setVisible(false);
        this.detachedDialog = new DetachedDialog();
        this.detachedDialog.setVisible(true);
        this.setIsShowing(true);
        this.setIsDocked(false);
    }

    public void collapse() {
        if (!this.isDialogInDefaultView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(false);
        this.setIsCollapsed(true);
        this.setPreferredSize(new Dimension(0, 20));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.setMinimumSize(new Dimension(Integer.MAX_VALUE, 20));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "minimized"));
    }

    protected void expand() {
        if (!this.isDialogInCollapsedView()) {
            throw new IllegalStateException();
        }
        this.setContentVisible(true);
        this.setIsCollapsed(false);
        this.setPreferredSize(new Dimension(0, this.preferredHeight));
        this.setMaximumSize(new Dimension(Integer.MAX_VALUE, Integer.MAX_VALUE));
        this.lblMinimized.setIcon(ImageProvider.get("misc", "normal"));
    }

    protected void setContentVisible(boolean bl) {
        Component[] componentArray = this.getComponents();
        for (int i = 0; i < componentArray.length; ++i) {
            if (componentArray[i] == this.titleBar) continue;
            componentArray[i].setVisible(bl);
        }
    }

    public void destroy() {
        this.closeDetachedDialog();
        this.hideNotify();
        Main.main.menu.windowMenu.remove(this.windowMenuItem);
        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
        this.destroyComponents(this);
    }

    private void destroyComponents(Component component) {
        if (component instanceof Container) {
            for (Component component2 : ((Container)component).getComponents()) {
                this.destroyComponents(component2);
            }
        }
        if (component instanceof Destroyable) {
            ((Destroyable)((Object)component)).destroy();
        }
    }

    public void closeDetachedDialog() {
        if (this.detachedDialog != null) {
            this.detachedDialog.setVisible(false);
            this.detachedDialog.getContentPane().removeAll();
            this.detachedDialog.dispose();
        }
    }

    public void showNotify() {
    }

    public void hideNotify() {
    }

    public AbstractAction getToggleAction() {
        return this.toggleAction;
    }

    public String getPreferencePrefix() {
        return this.preferencePrefix;
    }

    public void setDialogsPanel(DialogsPanel dialogsPanel) {
        this.dialogsPanel = dialogsPanel;
    }

    @Override
    public String getName() {
        return "toggleDialog." + this.preferencePrefix;
    }

    public void setTitle(String string) {
        this.titleBar.setTitle(string);
        if (this.detachedDialog != null) {
            this.detachedDialog.setTitle(string);
        }
    }

    protected void setIsShowing(boolean bl) {
        this.isShowing = bl;
        Main.pref.put(this.preferencePrefix + ".visible", bl);
        this.stateChanged();
    }

    protected void setIsDocked(boolean bl) {
        if (this.buttonsPanel != null && this.buttonsHide != null) {
            this.buttonsPanel.setVisible(bl ? this.buttonHiding == ButtonHiddingType.ALWAYS_SHOWN : true);
        }
        this.isDocked = bl;
        Main.pref.put(this.preferencePrefix + ".docked", bl);
        this.stateChanged();
    }

    protected void setIsCollapsed(boolean bl) {
        this.isCollapsed = bl;
        Main.pref.put(this.preferencePrefix + ".minimized", bl);
        this.stateChanged();
    }

    protected void setIsButtonHiding(ButtonHiddingType buttonHiddingType) {
        this.buttonHiding = buttonHiddingType;
        this.PROP_BUTTON_HIDING.put(buttonHiddingType, new String[0]);
        if (this.buttonsHide != null) {
            this.buttonsHide.setIcon(ImageProvider.get("misc", buttonHiddingType != ButtonHiddingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
        }
        if (this.buttonsPanel != null) {
            this.buttonsPanel.setVisible(buttonHiddingType != ButtonHiddingType.ALWAYS_HIDDEN);
        }
        this.stateChanged();
    }

    public int getPreferredHeight() {
        return this.preferredHeight;
    }

    @Override
    public String helpTopic() {
        String string = this.getClass().getName();
        string = string.substring(string.lastIndexOf(46) + 1, string.length() - 6);
        return "Dialog/" + string;
    }

    @Override
    public String toString() {
        return this.name;
    }

    public boolean isDialogShowing() {
        return this.isShowing;
    }

    public boolean isDialogInDefaultView() {
        return this.isShowing && this.isDocked && !this.isCollapsed;
    }

    public boolean isDialogInCollapsedView() {
        return this.isShowing && this.isDocked && this.isCollapsed;
    }

    public void setButton(JToggleButton jToggleButton) {
        this.button = jToggleButton;
    }

    public JToggleButton getButton() {
        return this.button;
    }

    protected Rectangle getDetachedGeometry(Rectangle rectangle) {
        return rectangle;
    }

    protected Dimension getDefaultDetachedSize() {
        return new Dimension(this.dialogsPanel.getWidth(), this.preferredHeight);
    }

    protected void toggleButtonHook() {
    }

    protected boolean dockWhenClosingDetachedDlg() {
        return true;
    }

    protected void stateChanged() {
    }

    protected Component createLayout(Component component, boolean bl, Collection<SideButton> collection) {
        return this.createLayout(component, bl, collection, null);
    }

    protected Component createLayout(Component component, boolean bl, Collection<SideButton> collection, Collection<SideButton> ... collectionArray) {
        if (bl) {
            component = new JScrollPane(component);
        }
        LinkedList<Collection<SideButton>> linkedList = new LinkedList<Collection<SideButton>>();
        linkedList.addFirst(collection);
        if (collectionArray != null) {
            linkedList.addAll(Arrays.asList(collectionArray));
        }
        this.add(component, "Center");
        if (linkedList.size() > 0 && linkedList.get(0) != null && !((Collection)linkedList.get(0)).isEmpty()) {
            this.buttonsPanel = new JPanel(new GridLayout(linkedList.size(), 1));
            for (Collection collection2 : linkedList) {
                if (collection2 == null) continue;
                JPanel jPanel = new JPanel(Main.pref.getBoolean("dialog.align.left", false) ? new FlowLayout(0) : new GridLayout(1, collection2.size()));
                this.buttonsPanel.add(jPanel);
                for (SideButton sideButton : collection2) {
                    jPanel.add(sideButton);
                    Action action = sideButton.getAction();
                    if (action != null) {
                        this.buttonActions.add(action);
                        continue;
                    }
                    System.err.println("Button " + sideButton + " doesn't have action defined");
                    new Exception().printStackTrace();
                }
            }
            this.add((Component)this.buttonsPanel, "South");
            if (Main.pref.getBoolean("dialog.dynamic.buttons", true)) {
                Toolkit.getDefaultToolkit().addAWTEventListener(this, 32L);
                this.buttonsPanel.setVisible(this.buttonHiding == ButtonHiddingType.ALWAYS_SHOWN || !this.isDocked);
            }
        } else if (this.buttonsHide != null) {
            this.buttonsHide.setVisible(false);
        }
        return component;
    }

    @Override
    public void eventDispatched(AWTEvent aWTEvent) {
        if (this.isShowing() && !this.isCollapsed && this.isDocked && this.buttonHiding == ButtonHiddingType.DYNAMIC) {
            Rectangle rectangle = this.getBounds();
            rectangle.setLocation(this.getLocationOnScreen());
            if (rectangle.contains(((MouseEvent)aWTEvent).getLocationOnScreen())) {
                if (!this.buttonsPanel.isVisible()) {
                    this.buttonsPanel.setVisible(true);
                }
            } else if (this.buttonsPanel.isVisible()) {
                this.buttonsPanel.setVisible(false);
            }
        }
    }

    private class DetachedDialog
    extends JDialog {
        public DetachedDialog() {
            super(JOptionPane.getFrameForComponent(Main.parent));
            this.getContentPane().add(ToggleDialog.this);
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    DetachedDialog.this.rememberGeometry();
                    DetachedDialog.this.getContentPane().removeAll();
                    DetachedDialog.this.dispose();
                    if (ToggleDialog.this.dockWhenClosingDetachedDlg()) {
                        ToggleDialog.this.dock();
                        if (ToggleDialog.this.isDialogInCollapsedView()) {
                            ToggleDialog.this.expand();
                        }
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.hideDialog();
                        ToggleDialog.this.hideNotify();
                    }
                }
            });
            this.addComponentListener(new ComponentAdapter(){

                public void componentMoved(ComponentEvent componentEvent) {
                    DetachedDialog.this.rememberGeometry();
                }

                public void componentResized(ComponentEvent componentEvent) {
                    DetachedDialog.this.rememberGeometry();
                }
            });
            try {
                new WindowGeometry(ToggleDialog.this.preferencePrefix + ".geometry").applySafe(this);
            }
            catch (WindowGeometry.WindowGeometryException windowGeometryException) {
                ToggleDialog.this.setPreferredSize(ToggleDialog.this.getDefaultDetachedSize());
                this.pack();
                this.setLocationRelativeTo(Main.parent);
            }
            this.setTitle(ToggleDialog.this.titleBar.getTitle());
            HelpUtil.setHelpContext(this.getRootPane(), ToggleDialog.this.helpTopic());
        }

        protected void rememberGeometry() {
            if (ToggleDialog.this.detachedDialog != null) {
                new WindowGeometry(ToggleDialog.this.detachedDialog).remember(ToggleDialog.this.preferencePrefix + ".geometry");
            }
        }
    }

    protected class TitleBar
    extends JPanel {
        private final JLabel lblTitle;
        private final JComponent lblTitle_weak;

        public TitleBar(String string, String string2) {
            this.setLayout(new GridBagLayout());
            ToggleDialog.this.lblMinimized = new JLabel(ImageProvider.get("misc", "normal"));
            this.add(ToggleDialog.this.lblMinimized);
            ImageIcon imageIcon = ImageProvider.get("dialogs", string2);
            ImageIcon imageIcon2 = new ImageIcon(imageIcon.getImage().getScaledInstance(16, 16, 4));
            this.lblTitle = new JLabel("", imageIcon2, 11);
            this.lblTitle.setIconTextGap(8);
            JPanel jPanel = new JPanel();
            jPanel.add(this.lblTitle);
            jPanel.setVisible(false);
            this.add((Component)jPanel, GBC.std());
            this.lblTitle_weak = new JComponent(){

                public void paintComponent(Graphics graphics) {
                    TitleBar.this.lblTitle.paint(graphics);
                }
            };
            this.lblTitle_weak.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
            this.lblTitle_weak.setMinimumSize(new Dimension(0, 20));
            this.add((Component)this.lblTitle_weak, GBC.std().fill(2));
            this.addMouseListener(new MouseAdapter(){

                public void mouseClicked(MouseEvent mouseEvent) {
                    if (ToggleDialog.this.isCollapsed) {
                        ToggleDialog.this.expand();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.COLLAPSED_TO_DEFAULT, ToggleDialog.this);
                    } else {
                        ToggleDialog.this.collapse();
                        ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    }
                }

                private void maybeShowPopup(MouseEvent mouseEvent) {
                    if (mouseEvent.isPopupTrigger()) {
                        JPopupMenu jPopupMenu = new JPopupMenu();
                        JMenu jMenu = new JMenu(I18n.tr("Side buttons", new Object[0]));
                        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always shown", new Object[0])){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ToggleDialog.this.setIsButtonHiding(ButtonHiddingType.ALWAYS_SHOWN);
                            }
                        });
                        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Dynamic", new Object[0])){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ToggleDialog.this.setIsButtonHiding(ButtonHiddingType.DYNAMIC);
                            }
                        });
                        JRadioButtonMenuItem jRadioButtonMenuItem3 = new JRadioButtonMenuItem(new AbstractAction(I18n.tr("Always hidden", new Object[0])){

                            public void actionPerformed(ActionEvent actionEvent) {
                                ToggleDialog.this.setIsButtonHiding(ButtonHiddingType.ALWAYS_HIDDEN);
                            }
                        });
                        jRadioButtonMenuItem.setSelected(ToggleDialog.this.buttonHiding == ButtonHiddingType.ALWAYS_SHOWN);
                        jRadioButtonMenuItem2.setSelected(ToggleDialog.this.buttonHiding == ButtonHiddingType.DYNAMIC);
                        jRadioButtonMenuItem3.setSelected(ToggleDialog.this.buttonHiding == ButtonHiddingType.ALWAYS_HIDDEN);
                        jMenu.add(jRadioButtonMenuItem);
                        jMenu.add(jRadioButtonMenuItem2);
                        jMenu.add(jRadioButtonMenuItem3);
                        jPopupMenu.add(jMenu);
                        for (Action action : ToggleDialog.this.buttonActions) {
                            jPopupMenu.add(action);
                        }
                        jPopupMenu.show(TitleBar.this, mouseEvent.getX(), mouseEvent.getY());
                    }
                }

                public void mousePressed(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }

                public void mouseReleased(MouseEvent mouseEvent) {
                    this.maybeShowPopup(mouseEvent);
                }
            });
            if (Main.pref.getBoolean("dialog.dynamic.buttons", true)) {
                ToggleDialog.this.buttonsHide = new JButton(ImageProvider.get("misc", ToggleDialog.this.buttonHiding != ButtonHiddingType.ALWAYS_SHOWN ? "buttonhide" : "buttonshow"));
                ToggleDialog.this.buttonsHide.setToolTipText(I18n.tr("Toggle dynamic buttons", new Object[0]));
                ToggleDialog.this.buttonsHide.setBorder(BorderFactory.createEmptyBorder());
                ToggleDialog.this.buttonsHide.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ToggleDialog.this.setIsButtonHiding(ToggleDialog.this.buttonHiding == ButtonHiddingType.ALWAYS_SHOWN ? ButtonHiddingType.DYNAMIC : ButtonHiddingType.ALWAYS_SHOWN);
                    }
                });
                this.add(ToggleDialog.this.buttonsHide);
            }
            JButton jButton = new JButton(ImageProvider.get("misc", "sticky"));
            jButton.setToolTipText(I18n.tr("Undock the panel", new Object[0]));
            jButton.setBorder(BorderFactory.createEmptyBorder());
            jButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleDialog.this.detach();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                }
            });
            this.add(jButton);
            JButton jButton2 = new JButton(ImageProvider.get("misc", "close"));
            jButton2.setToolTipText(I18n.tr("Close this panel. You can reopen it with the buttons in the left toolbar.", new Object[0]));
            jButton2.setBorder(BorderFactory.createEmptyBorder());
            jButton2.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    ToggleDialog.this.hideDialog();
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                    ToggleDialog.this.hideNotify();
                }
            });
            this.add(jButton2);
            this.setToolTipText(I18n.tr("Click to minimize/maximize the panel content", new Object[0]));
            this.setTitle(string);
        }

        public void setTitle(String string) {
            this.lblTitle.setText(string);
            this.lblTitle_weak.repaint();
        }

        public String getTitle() {
            return this.lblTitle.getText();
        }
    }

    public final class ToggleDialogAction
    extends JosmAction {
        private ToggleDialogAction(String string, String string2, String string3, Shortcut shortcut, String string4) {
            super(string, string2, string3, shortcut, false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ToggleDialog.this.toggleButtonHook();
            if (this.getValue("toolbarbutton") != null && this.getValue("toolbarbutton") instanceof JButton) {
                ((JButton)this.getValue("toolbarbutton")).setSelected(!ToggleDialog.this.isShowing);
            }
            if (ToggleDialog.this.isShowing) {
                ToggleDialog.this.hideDialog();
                ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.ELEMENT_SHRINKS, null);
                ToggleDialog.this.hideNotify();
            } else {
                ToggleDialog.this.showDialog();
                if (ToggleDialog.this.isDocked && ToggleDialog.this.isCollapsed) {
                    ToggleDialog.this.expand();
                }
                if (ToggleDialog.this.isDocked) {
                    ToggleDialog.this.dialogsPanel.reconstruct(DialogsPanel.Action.INVISIBLE_TO_DEFAULT, ToggleDialog.this);
                }
                ToggleDialog.this.showNotify();
            }
        }

        public void destroy() {
            super.destroy();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ButtonHiddingType {
        ALWAYS_SHOWN,
        ALWAYS_HIDDEN,
        DYNAMIC;

    }
}

