/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import org.openstreetmap.josm.data.Bounds;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.AbstractProjection;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.ProjectionConfigurationException;
import org.openstreetmap.josm.data.projection.datum.ThreeParameterDatum;
import org.openstreetmap.josm.data.projection.proj.ProjParameters;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.tools.I18n;

public class SwissGrid
extends AbstractProjection {
    public SwissGrid() {
        this.ellps = Ellipsoid.Bessel1841;
        this.datum = new ThreeParameterDatum("SwissGrid Datum", null, this.ellps, 674.374, 15.056, 405.346);
        this.x_0 = 600000.0;
        this.y_0 = 200000.0;
        this.lon_0 = 7.439583333333333;
        this.proj = new SwissObliqueMercator();
        try {
            this.proj.initialize(new ProjParameters(){
                {
                    this.ellps = SwissGrid.this.ellps;
                    this.lat_0 = 46.95240555555556;
                }
            });
        }
        catch (ProjectionConfigurationException projectionConfigurationException) {
            throw new RuntimeException(projectionConfigurationException);
        }
    }

    public String toString() {
        return I18n.tr("Swiss Grid (Switzerland)", new Object[0]);
    }

    public Integer getEpsgCode() {
        return 21781;
    }

    public int hashCode() {
        return this.getClass().getName().hashCode();
    }

    public String getCacheDirectoryName() {
        return "swissgrid";
    }

    public Bounds getWorldBoundsLatLon() {
        return new Bounds(new LatLon(45.7, 5.7), new LatLon(47.9, 10.6), false);
    }
}

