/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.projection;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.coor.EastNorth;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.data.projection.Ellipsoid;
import org.openstreetmap.josm.data.projection.datum.Datum;
import org.openstreetmap.josm.data.projection.datum.NTV2GridShiftFileWrapper;
import org.openstreetmap.josm.data.projection.datum.WGS84Datum;
import org.openstreetmap.josm.data.projection.proj.ClassProjFactory;
import org.openstreetmap.josm.data.projection.proj.LambertConformalConic;
import org.openstreetmap.josm.data.projection.proj.LonLat;
import org.openstreetmap.josm.data.projection.proj.Mercator;
import org.openstreetmap.josm.data.projection.proj.Proj;
import org.openstreetmap.josm.data.projection.proj.ProjFactory;
import org.openstreetmap.josm.data.projection.proj.SwissObliqueMercator;
import org.openstreetmap.josm.data.projection.proj.TransverseMercator;
import org.openstreetmap.josm.io.MirroredInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Projections {
    public static Map<String, ProjFactory> projs = new HashMap<String, ProjFactory>();
    public static Map<String, Ellipsoid> ellipsoids = new HashMap<String, Ellipsoid>();
    public static Map<String, Datum> datums = new HashMap<String, Datum>();
    public static Map<String, NTV2GridShiftFileWrapper> nadgrids = new HashMap<String, NTV2GridShiftFileWrapper>();
    public static Map<String, String> inits = new HashMap<String, String>();

    public static EastNorth project(LatLon latLon) {
        if (latLon == null) {
            return null;
        }
        return Main.getProjection().latlon2eastNorth(latLon);
    }

    public static LatLon inverseProject(EastNorth eastNorth) {
        if (eastNorth == null) {
            return null;
        }
        return Main.getProjection().eastNorth2latlon(eastNorth);
    }

    public static void registerBaseProjection(String string, ProjFactory projFactory, String string2) {
        projs.put(string, projFactory);
    }

    public static void registerBaseProjection(String string, Class<? extends Proj> clazz, String string2) {
        Projections.registerBaseProjection(string, new ClassProjFactory(clazz), string2);
    }

    public static Proj getBaseProjection(String string) {
        ProjFactory projFactory = projs.get(string);
        if (projFactory == null) {
            return null;
        }
        return projFactory.createInstance();
    }

    public static Ellipsoid getEllipsoid(String string) {
        return ellipsoids.get(string);
    }

    public static Datum getDatum(String string) {
        return datums.get(string);
    }

    public static NTV2GridShiftFileWrapper getNTV2Grid(String string) {
        return nadgrids.get(string);
    }

    public static String getInit(String string) {
        return inits.get(string);
    }

    private static void loadInits() {
        Pattern pattern = Pattern.compile("\\A<(\\d+)>(.*)<>\\Z");
        try {
            String string;
            MirroredInputStream mirroredInputStream = new MirroredInputStream("resource://data/epsg");
            BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(mirroredInputStream));
            while ((string = bufferedReader.readLine()) != null) {
                if ((string = string.trim()).startsWith("#") || string.isEmpty()) continue;
                Matcher matcher = pattern.matcher(string);
                if (matcher.matches()) {
                    inits.put("epsg:" + matcher.group(1), matcher.group(2).trim());
                    continue;
                }
                System.err.println("Warning: failed to parse line from the epsg projection definition: " + string);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException();
        }
    }

    static {
        Projections.registerBaseProjection("lonlat", LonLat.class, "core");
        Projections.registerBaseProjection("josm:smerc", Mercator.class, "core");
        Projections.registerBaseProjection("lcc", LambertConformalConic.class, "core");
        Projections.registerBaseProjection("somerc", SwissObliqueMercator.class, "core");
        Projections.registerBaseProjection("tmerc", TransverseMercator.class, "core");
        ellipsoids.put("intl", Ellipsoid.hayford);
        ellipsoids.put("GRS80", Ellipsoid.GRS80);
        ellipsoids.put("WGS84", Ellipsoid.WGS84);
        ellipsoids.put("bessel", Ellipsoid.Bessel1841);
        datums.put("WGS84", WGS84Datum.INSTANCE);
        nadgrids.put("BETA2007.gsb", NTV2GridShiftFileWrapper.BETA2007);
        nadgrids.put("ntf_r93_b.gsb", NTV2GridShiftFileWrapper.ntf_rgf93);
        Projections.loadInits();
    }
}

