/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.imagery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.data.imagery.ImageryInfo;
import org.openstreetmap.josm.io.MirroredInputStream;
import org.openstreetmap.josm.io.imagery.ImageryReader;
import org.openstreetmap.josm.tools.Utils;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ImageryLayerInfo {
    public static final ImageryLayerInfo instance = new ImageryLayerInfo();
    ArrayList<ImageryInfo> layers = new ArrayList();
    static ArrayList<ImageryInfo> defaultLayers = new ArrayList();
    private static final String[] DEFAULT_LAYER_SITES = new String[]{"http://josm.openstreetmap.de/maps"};

    private ImageryLayerInfo() {
    }

    public ImageryLayerInfo(ImageryLayerInfo imageryLayerInfo) {
        this.layers.addAll(imageryLayerInfo.layers);
    }

    public void clear() {
        this.layers.clear();
    }

    public void load() {
        boolean bl = this.layers.size() != 0;
        List<ImageryInfo.ImageryPreferenceEntry> list = Main.pref.getListOfStructs("imagery.entries", null, ImageryInfo.ImageryPreferenceEntry.class);
        if (list != null) {
            for (ImageryInfo.ImageryPreferenceEntry imageryPreferenceEntry : list) {
                try {
                    ImageryInfo imageryInfo = new ImageryInfo(imageryPreferenceEntry);
                    this.add(imageryInfo);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    System.err.println("Warning: Unable to load imagery preference entry:" + illegalArgumentException);
                }
            }
            Collections.sort(this.layers);
        }
        if (bl) {
            this.save();
        }
    }

    public void loadDefaults(boolean bl) {
        defaultLayers.clear();
        for (String object2 : Main.pref.getCollection("imagery.layers.sites", Arrays.asList(DEFAULT_LAYER_SITES))) {
            if (bl) {
                MirroredInputStream.cleanup(object2);
            }
            Iterator<ImageryInfo> iterator = null;
            try {
                ImageryReader sAXException = new ImageryReader(object2);
                List<ImageryInfo> list = sAXException.parse();
                defaultLayers.addAll(list);
            }
            catch (IOException iOException) {
                Utils.close(iterator);
                iOException.printStackTrace();
            }
            catch (SAXException sAXException) {
                Utils.close(iterator);
                sAXException.printStackTrace();
            }
        }
        while (defaultLayers.remove(null)) {
        }
        Collection<String> collection = Main.pref.getCollection("imagery.layers.default");
        ArrayList<String> arrayList = new ArrayList<String>();
        for (ImageryInfo imageryInfo : defaultLayers) {
            if (!imageryInfo.isDefaultEntry()) continue;
            arrayList.add(imageryInfo.getUrl());
            boolean bl2 = false;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                if (!this.isSimilar(string, imageryInfo.getUrl())) continue;
                bl2 = true;
                break;
            }
            boolean bl3 = false;
            if (!bl2) {
                for (ImageryInfo imageryInfo2 : this.layers) {
                    if (!this.isSimilar(imageryInfo.getUrl(), imageryInfo2.getUrl())) continue;
                    bl3 = true;
                    break;
                }
            }
            if (bl2 || bl3) continue;
            this.add(new ImageryInfo(imageryInfo));
        }
        Collections.sort(defaultLayers);
        Main.pref.putCollection("imagery.layers.default", (Collection<String>)(arrayList.size() > 0 ? arrayList : collection));
    }

    private boolean isSimilar(String string, String string2) {
        return Utils.equal(string, string2) || string != null && string2 != null && !"".equals(string) && !"".equals(string2) && (string.contains(string2) || string2.contains(string));
    }

    public void add(ImageryInfo imageryInfo) {
        this.layers.add(imageryInfo);
    }

    public void remove(ImageryInfo imageryInfo) {
        this.layers.remove(imageryInfo);
    }

    public void save() {
        ArrayList<ImageryInfo.ImageryPreferenceEntry> arrayList = new ArrayList<ImageryInfo.ImageryPreferenceEntry>();
        for (ImageryInfo imageryInfo : this.layers) {
            arrayList.add(new ImageryInfo.ImageryPreferenceEntry(imageryInfo));
        }
        Main.pref.putListOfStructs("imagery.entries", arrayList, ImageryInfo.ImageryPreferenceEntry.class);
    }

    public List<ImageryInfo> getLayers() {
        return Collections.unmodifiableList(this.layers);
    }

    public List<ImageryInfo> getDefaultLayers() {
        return Collections.unmodifiableList(defaultLayers);
    }

    public static void addLayer(ImageryInfo imageryInfo) {
        instance.add(imageryInfo);
        instance.save();
        Main.main.menu.imageryMenu.refreshImageryMenu();
    }

    public static void addLayers(Collection<ImageryInfo> collection) {
        for (ImageryInfo imageryInfo : collection) {
            instance.add(imageryInfo);
        }
        instance.save();
        Collections.sort(ImageryLayerInfo.instance.layers);
        Main.main.menu.imageryMenu.refreshImageryMenu();
    }
}

