/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.openstreetmap.josm.Main;
import org.openstreetmap.josm.actions.JosmAction;
import org.openstreetmap.josm.command.AddCommand;
import org.openstreetmap.josm.command.ChangeCommand;
import org.openstreetmap.josm.command.ChangePropertyCommand;
import org.openstreetmap.josm.command.Command;
import org.openstreetmap.josm.command.SequenceCommand;
import org.openstreetmap.josm.data.osm.AbstractPrimitive;
import org.openstreetmap.josm.data.osm.MultipolygonCreate;
import org.openstreetmap.josm.data.osm.OsmPrimitive;
import org.openstreetmap.josm.data.osm.Relation;
import org.openstreetmap.josm.data.osm.RelationMember;
import org.openstreetmap.josm.data.osm.Way;
import org.openstreetmap.josm.gui.dialogs.relation.RelationEditor;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Shortcut;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateMultipolygonAction
extends JosmAction {
    public static final List<String> DEFAULT_LINEAR_TAGS = Arrays.asList("barrier", "source");

    public CreateMultipolygonAction() {
        super(I18n.tr("Create multipolygon", new Object[0]), "multipoly_create", I18n.tr("Create multipolygon.", new Object[0]), Shortcut.registerShortcut("tools:multipoly", I18n.tr("Tool: {0}", I18n.tr("Create multipolygon", new Object[0])), 65, 5008), true);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (Main.main.getEditLayer() == null) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("No data loaded.", new Object[0]));
            return;
        }
        Collection<Way> collection = Main.main.getCurrentDataSet().getSelectedWays();
        if (collection.size() < 1) {
            JOptionPane.showMessageDialog(Main.parent, I18n.tr("You must select at least one way.", new Object[0]));
            return;
        }
        MultipolygonCreate multipolygonCreate = this.analyzeWays(collection);
        if (multipolygonCreate == null) {
            return;
        }
        final Relation relation = this.createRelation(multipolygonCreate);
        if (Main.pref.getBoolean("multipoly.show-relation-editor", false)) {
            RelationEditor relationEditor = RelationEditor.getEditor(Main.main.getEditLayer(), relation, null);
            relationEditor.setModal(true);
            relationEditor.setVisible(true);
        } else {
            List<Command> list = this.removeTagsFromWaysIfNeeded(relation);
            list.add(new AddCommand(relation));
            Main.main.undoRedo.add(new SequenceCommand(I18n.tr("Create multipolygon", new Object[0]), list));
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    Main.map.relationListDialog.selectRelation(relation);
                }
            });
        }
    }

    @Override
    protected void updateEnabledState() {
        if (CreateMultipolygonAction.getCurrentDataSet() == null) {
            this.setEnabled(false);
        } else {
            this.updateEnabledState(CreateMultipolygonAction.getCurrentDataSet().getSelected());
        }
    }

    @Override
    protected void updateEnabledState(Collection<? extends OsmPrimitive> collection) {
        this.setEnabled(collection != null && !collection.isEmpty());
    }

    private MultipolygonCreate analyzeWays(Collection<Way> collection) {
        MultipolygonCreate multipolygonCreate = new MultipolygonCreate();
        String string = multipolygonCreate.makeFromWays(collection);
        if (string != null) {
            JOptionPane.showMessageDialog(Main.parent, string);
            return null;
        }
        return multipolygonCreate;
    }

    private Relation createRelation(MultipolygonCreate multipolygonCreate) {
        Relation relation = new Relation();
        relation.put("type", "multipolygon");
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.outerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("outer", way));
            }
        }
        for (MultipolygonCreate.JoinedPolygon joinedPolygon : multipolygonCreate.innerWays) {
            for (Way way : joinedPolygon.ways) {
                relation.addMember(new RelationMember("inner", way));
            }
        }
        return relation;
    }

    private List<Command> removeTagsFromWaysIfNeeded(Relation relation) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (relation.hasKeys()) {
            for (String object2 : relation.keySet()) {
                hashMap.put(object2, relation.get(object2));
            }
        }
        ArrayList arrayList = new ArrayList();
        ArrayList<Way> arrayList2 = new ArrayList<Way>();
        TreeSet<Object> treeSet = new TreeSet<Object>();
        for (RelationMember bl : relation.getMembers()) {
            if (bl.hasRole() && "inner".equals(bl.getRole()) && bl.isWay() && bl.getWay().hasKeys()) {
                arrayList.add(bl.getWay());
            }
            if (!bl.hasRole() || !"outer".equals(bl.getRole()) || !bl.isWay() || !bl.getWay().hasKeys()) continue;
            Iterator iterator = bl.getWay();
            arrayList2.add((Way)((Object)iterator));
            for (String string : ((AbstractPrimitive)((Object)iterator)).keySet()) {
                if (!hashMap.containsKey(string)) {
                    hashMap.put(string, ((AbstractPrimitive)((Object)iterator)).get(string));
                    continue;
                }
                if (relation.hasKey(string) || ((String)hashMap.get(string)).equals(((AbstractPrimitive)((Object)iterator)).get(string))) continue;
                treeSet.add(string);
            }
        }
        if (!Main.pref.getBoolean("multipoly.alltags", false)) {
            for (RelationMember relationMember : relation.getMembers()) {
                if (!relationMember.hasRole() || !relationMember.getRole().equals("outer") || !relationMember.isWay()) continue;
                for (Object object : hashMap.keySet()) {
                    if (relationMember.getWay().hasKey((String)object) || relation.hasKey((String)object)) continue;
                    treeSet.add(object);
                }
            }
        }
        for (String string : treeSet) {
            hashMap.remove(string);
        }
        for (String string : Main.pref.getCollection("multipoly.lineartagstokeep", DEFAULT_LINEAR_TAGS)) {
            hashMap.remove(string);
        }
        if (hashMap.containsKey("natural") && ((String)hashMap.get("natural")).equals("coastline")) {
            hashMap.remove("natural");
        }
        hashMap.put("area", "yes");
        ArrayList arrayList3 = new ArrayList();
        boolean bl = Main.pref.getBoolean("multipoly.movetags", true);
        for (Object object : hashMap.keySet()) {
            ArrayList<Way> arrayList4 = new ArrayList<Way>();
            String string = (String)hashMap.get(object);
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Way way = (Way)iterator.next();
                if (!way.hasKey((String)object) || !string.equals(way.get((String)object))) continue;
                arrayList4.add(way);
            }
            if (bl) {
                for (Way way : arrayList2) {
                    if (!way.hasKey((String)object)) continue;
                    arrayList4.add(way);
                }
            }
            if (arrayList4.size() <= 0) continue;
            arrayList3.add(new ChangePropertyCommand(arrayList4, (String)object, null));
        }
        if (bl) {
            Object object;
            boolean bl2 = false;
            object = new Relation(relation);
            for (String string : hashMap.keySet()) {
                if (((AbstractPrimitive)object).hasKey(string) || string.equals("area")) continue;
                if (relation.isNew()) {
                    relation.put(string, (String)hashMap.get(string));
                } else {
                    ((OsmPrimitive)object).put(string, (String)hashMap.get(string));
                }
                bl2 = true;
            }
            if (bl2 && !relation.isNew()) {
                arrayList3.add(new ChangeCommand(relation, (OsmPrimitive)object));
            }
        }
        return arrayList3;
    }
}

