/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer.tilesources;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.xml.bind.DatatypeConverter;
import org.openstreetmap.gui.jmapviewer.interfaces.TileSource;
import org.openstreetmap.gui.jmapviewer.tilesources.AbstractOsmTileSource;

public class AbstractMapQuestTileSource
extends AbstractOsmTileSource {
    private static final String LOGO_BASE64 = "iVBORw0KGgoAAAANSUhEUgAAABAAAAAQCAYAAAAf8/9hAAAAGXRFWHRTb2Z0d2FyZQBBZG9iZSBJbWFnZVJlYWR5ccllPAAAAZtJREFUeNpi/P//P0PPcYf/DGSAEssDjIzdx+zJ0gwDLMQqVBWyZVAStGRgBMK33x8wnH62kngD+DmkGBwUshn42SXA/P8M/xg+/3rDcOPNPuIMMJeKAmv+8OMpw7ffHxikeLUZXBTzgez3DEzEGMDGzAmmjz5ewLDqWiHE6UwcDHxsYhAXsLPwMFhKxzIIccozPP18ieHhx3MMGsKOYP7td4fBzgUBN+ViBkeFLDD7zbf7DK++3WFgAMXC448X/uMDV17t+H/r7UEM8VNPl/8Hu0CGTx9s6tXXOxhEuJQYxLnVgK44w/Dzz1cGNWF7BlGg2KJLqQzCQBcxMbEw/P77g0FTxBkYJs8gXgCFKiMwOLbf6WDQF/djcFUqAvv33fdHYAM4WPjAFrz9/hAeLsefLALT4EBkhIYlMxMrAxerIJjNCdTExy4OZv/59xNnAKPEAh+bBNAQSMwKcsgAQ5odzBbilGNghcYE1pS4+14fMKq4GP79/w1OHCC/v/x6Exzv+x9MhbiOEeh3LAZQnBeYGCgEjJRmZ4AAAwCE6rplT3Ba/gAAAABJRU5ErkJggg==";
    protected static final String MAPQUEST_ATTRIBUTION = "Tiles Courtesy of MapQuest ";
    protected static final String MAPQUEST_WEBSITE = "http://www.mapquest.com";
    private static final int NUMBER_OF_SERVERS = 4;
    private int SERVER_NUM = 1;

    public AbstractMapQuestTileSource(String string, String string2) {
        super(string, string2);
    }

    public String getBaseUrl() {
        String string = String.format(this.baseUrl, this.SERVER_NUM);
        this.SERVER_NUM = this.SERVER_NUM % 4 + 1;
        return string;
    }

    public TileSource.TileUpdate getTileUpdate() {
        return TileSource.TileUpdate.IfModifiedSince;
    }

    public Image getAttributionImage() {
        try {
            return ImageIO.read(new ByteArrayInputStream(DatatypeConverter.parseBase64Binary((String)LOGO_BASE64)));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return null;
        }
    }

    public String getAttributionImageURL() {
        return MAPQUEST_WEBSITE;
    }

    public String getTermsOfUseURL() {
        return "http://developer.mapquest.com/web/products/open/map#terms";
    }
}

