/*
 * Decompiled with CFR 0.152.
 */
package sun.lwawt.macosx;

import java.awt.Cursor;
import java.awt.Point;
import java.awt.geom.Point2D;
import sun.lwawt.LWCursorManager;
import sun.lwawt.macosx.CCustomCursor;

final class CCursorManager
extends LWCursorManager {
    private static final int NAMED_CURSOR = -1;
    private static final CCursorManager theInstance = new CCursorManager();
    private volatile Cursor currentCursor;
    private boolean isDragging = false;
    private Point dragPos = null;

    private static native Point2D nativeGetCursorPosition();

    private static native void nativeSetBuiltInCursor(int var0, String var1);

    private static native void nativeSetCustomCursor(long var0, double var2, double var4);

    public static native void nativeSetAllowsCursorSetInBackground(boolean var0);

    public static CCursorManager getInstance() {
        return theInstance;
    }

    private CCursorManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Point getCursorPosition() {
        Object object = this;
        synchronized (object) {
            if (this.isDragging) {
                return new Point(this.dragPos);
            }
        }
        object = CCursorManager.nativeGetCursorPosition();
        return new Point((int)((Point2D)object).getX(), (int)((Point2D)object).getY());
    }

    @Override
    protected void setCursor(Cursor cursor) {
        if (cursor == this.currentCursor) {
            return;
        }
        this.currentCursor = cursor;
        if (cursor == null) {
            CCursorManager.nativeSetBuiltInCursor(0, null);
            return;
        }
        if (cursor instanceof CCustomCursor) {
            CCustomCursor cCustomCursor = (CCustomCursor)cursor;
            long l = cCustomCursor.getImageData();
            if (l != 0L) {
                Point point = cCustomCursor.getHotSpot();
                CCursorManager.nativeSetCustomCursor(l, point.x, point.y);
            }
            return;
        }
        int n = cursor.getType();
        if (n != -1) {
            CCursorManager.nativeSetBuiltInCursor(n, null);
            return;
        }
        String string = cursor.getName();
        if (string != null) {
            CCursorManager.nativeSetBuiltInCursor(-1, string);
            return;
        }
        throw new RuntimeException("Unimplemented");
    }

    synchronized void startDrag(int n, int n2) {
        if (this.isDragging) {
            throw new RuntimeException("Invalid Drag state in CCursorManager!");
        }
        this.isDragging = true;
        this.dragPos = new Point(n, n2);
    }

    synchronized void updateDragPosition(int n, int n2) {
        if (!this.isDragging) {
            throw new RuntimeException("Invalid Drag state in CCursorManager!");
        }
        this.dragPos.move(n, n2);
    }

    synchronized void stopDrag() {
        if (!this.isDragging) {
            throw new RuntimeException("Invalid Drag state in CCursorManager!");
        }
        this.isDragging = false;
        this.dragPos = null;
    }
}

