/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.model;

import com.theoryinpractice.testng.ui.TestNGConsoleView;
import com.theoryinpractice.testng.ui.TestNGResults;
import org.testng.remote.strprotocol.GenericMessage;
import org.testng.remote.strprotocol.IRemoteSuiteListener;
import org.testng.remote.strprotocol.IRemoteTestListener;
import org.testng.remote.strprotocol.SuiteMessage;
import org.testng.remote.strprotocol.TestMessage;
import org.testng.remote.strprotocol.TestResultMessage;

public class TestNGRemoteListener
implements IRemoteSuiteListener,
IRemoteTestListener {
    private final TestNGConsoleView console;

    public TestNGRemoteListener(TestNGConsoleView console) {
        this.console = console;
    }

    public void onInitialization(GenericMessage genericMessage) {
    }

    public void onStart(SuiteMessage suiteMessage) {
        TestNGResults view = this.console.getResultsView();
        if (view != null) {
            view.start();
        }
    }

    public void onFinish(SuiteMessage suiteMessage) {
        this.console.flush();
        TestNGResults view = this.console.getResultsView();
        if (view != null) {
            view.finish();
        }
    }

    public void onStart(TestMessage tm) {
        TestNGResults view = this.console.getResultsView();
        if (view != null) {
            view.setTotal(tm.getTestMethodCount());
        }
    }

    public void onTestStart(TestResultMessage trm) {
        this.console.testStarted(trm);
    }

    public void onFinish(TestMessage tm) {
        this.console.rebuildTree();
    }

    public void onTestSuccess(TestResultMessage trm) {
        this.console.addTestResult(trm);
    }

    public void onTestFailure(TestResultMessage trm) {
        this.console.addTestResult(trm);
    }

    public void onTestSkipped(TestResultMessage trm) {
        this.console.addTestResult(trm);
    }

    public void onTestFailedButWithinSuccessPercentage(TestResultMessage trm) {
    }
}

