/*
 * Decompiled with CFR 0.152.
 */
package com.theoryinpractice.testng.configuration.browser;

import com.intellij.ide.structureView.impl.StructureNodeRenderer;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.util.PsiFormatUtil;
import com.intellij.ui.ColoredListCellRenderer;
import com.intellij.ui.ListScrollingUtil;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.SortedListModel;
import com.theoryinpractice.testng.util.TestNGUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.ListModel;

public class MethodList
extends JPanel {
    private final SortedListModel<PsiMethod> model = new SortedListModel(comparator);
    private final JList list = new JList<PsiMethod>((ListModel<PsiMethod>)this.model);
    private final PsiClass psiClass;
    private static final Comparator<PsiMethod> comparator = new Comparator<PsiMethod>(){

        @Override
        public int compare(PsiMethod method1, PsiMethod method2) {
            return method1.getName().compareToIgnoreCase(method2.getName());
        }
    };

    public MethodList(PsiClass psiClass) {
        super(new BorderLayout());
        this.psiClass = psiClass;
        this.evaluate(psiClass.getAllMethods(), new TestMethodFilter());
        this.add(ScrollPaneFactory.createScrollPane((JComponent)this.list));
        this.list.setCellRenderer(new ColoredListCellRenderer(){

            protected void customizeCellRenderer(JList jlist, Object obj, int i, boolean flag, boolean flag1) {
                PsiMethod psimethod = (PsiMethod)obj;
                this.append(PsiFormatUtil.formatMethod((PsiMethod)psimethod, (PsiSubstitutor)PsiSubstitutor.EMPTY, (int)1, (int)0), StructureNodeRenderer.applyDeprecation((Object)psimethod, (SimpleTextAttributes)SimpleTextAttributes.REGULAR_ATTRIBUTES));
                PsiClass psiclass1 = psimethod.getContainingClass();
                if (!MethodList.this.psiClass.equals(psiclass1)) {
                    this.append(" (" + psiclass1.getQualifiedName() + ')', StructureNodeRenderer.applyDeprecation((Object)psiclass1, (SimpleTextAttributes)SimpleTextAttributes.GRAY_ATTRIBUTES));
                }
            }
        });
        this.list.setSelectionMode(0);
        ListScrollingUtil.ensureSelectionExists((JList)this.list);
    }

    private void evaluate(PsiMethod[] methods, Condition<PsiMethod> condition) {
        for (PsiMethod psimethod : methods) {
            if (!condition.value((Object)psimethod)) continue;
            this.model.add((Object)psimethod);
        }
    }

    public PsiMethod getSelected() {
        return (PsiMethod)this.list.getSelectedValue();
    }

    public static PsiMethod showDialog(PsiClass psiClass, JComponent component) {
        MethodList list = new MethodList(psiClass);
        DialogBuilder builder = new DialogBuilder((Component)component);
        builder.setCenterPanel((JComponent)list);
        builder.setPreferedFocusComponent((JComponent)list.list);
        builder.setTitle("Choose Test Method");
        return builder.show() != 0 ? null : list.getSelected();
    }

    public static class TestMethodFilter
    implements Condition<PsiMethod> {
        public boolean value(PsiMethod method) {
            return TestNGUtil.hasTest((PsiModifierListOwner)method);
        }
    }
}

