/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.buildServer.messages.serviceMessages;

import java.text.ParseException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.BuildNumber;
import jetbrains.buildServer.messages.serviceMessages.BuildStatisticValue;
import jetbrains.buildServer.messages.serviceMessages.BuildStatus;
import jetbrains.buildServer.messages.serviceMessages.ProgressFinish;
import jetbrains.buildServer.messages.serviceMessages.ProgressMessage;
import jetbrains.buildServer.messages.serviceMessages.ProgressStart;
import jetbrains.buildServer.messages.serviceMessages.PublishArtifacts;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import jetbrains.buildServer.messages.serviceMessages.TestFailed;
import jetbrains.buildServer.messages.serviceMessages.TestFinished;
import jetbrains.buildServer.messages.serviceMessages.TestIgnored;
import jetbrains.buildServer.messages.serviceMessages.TestStarted;
import jetbrains.buildServer.messages.serviceMessages.TestStdErr;
import jetbrains.buildServer.messages.serviceMessages.TestStdOut;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteFinished;
import jetbrains.buildServer.messages.serviceMessages.TestSuiteStarted;
import jetbrains.buildServer.util.StringUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ServiceMessage {
    @NonNls
    private static final Pattern SERVICE_MESSAGE_PATTERN = Pattern.compile("##teamcity\\[(.*)\\]");
    private String myMessageName;
    private Map<String, String> myAttributes;
    private String myArgument;
    private static Map<String, Class<? extends ServiceMessage>> myServiceMessageClasses = new HashMap<String, Class<? extends ServiceMessage>>();
    private static final StringUtil.EscapeInfoProvider STD_ESCAPER;

    ServiceMessage() {
    }

    private void init(@NotNull String key, @Nullable String argumentsStr) throws ParseException {
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.init must not be null");
        }
        if (key == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.init must not be null");
        }
        this.myMessageName = key;
        if (argumentsStr != null && argumentsStr.startsWith("'")) {
            this.parseArgument(argumentsStr);
        } else {
            this.parseAttributes(argumentsStr);
        }
    }

    @Nullable
    public static ServiceMessage parse(@NotNull String text) throws ParseException {
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.parse must not be null");
        }
        if (text == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.parse must not be null");
        }
        return ServiceMessage.doParse(text);
    }

    @NotNull
    public String getMessageName() {
        String string = this.myMessageName;
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/messages/serviceMessages/ServiceMessage.getMessageName must not return null");
        }
        if (string == null) {
            throw new IllegalStateException("@NotNull method jetbrains/buildServer/messages/serviceMessages/ServiceMessage.getMessageName must not return null");
        }
        return string;
    }

    @Nullable
    public String getArgument() {
        return this.myArgument;
    }

    public Map<String, String> getAttributes() {
        return this.myAttributes;
    }

    private void parseArgument(String argumentsStr) throws ParseException {
        this.myArgument = argumentsStr == null ? null : this.stringToText(argumentsStr);
    }

    private void parseAttributes(String argumentsStr) throws ParseException {
        this.myAttributes = argumentsStr != null ? StringUtil.stringToProperties(argumentsStr, STD_ESCAPER) : Collections.emptyMap();
    }

    public void visit(@NotNull ServiceMessageVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.visit must not be null");
        }
        if (visitor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.visit must not be null");
        }
        visitor.visitServiceMessage(this);
    }

    @Nullable
    private static ServiceMessage doParse(String text) throws ParseException {
        Matcher matcher = SERVICE_MESSAGE_PATTERN.matcher(text.trim());
        if (!matcher.matches()) {
            return null;
        }
        String keyWithArguments = matcher.group(1);
        int sepIndex = keyWithArguments.indexOf(" ");
        String key = sepIndex == -1 ? keyWithArguments : keyWithArguments.substring(0, sepIndex);
        String argumentsStr = sepIndex == -1 ? null : keyWithArguments.substring(sepIndex).trim();
        Class<? extends ServiceMessage> clazz = myServiceMessageClasses.get(key);
        if (clazz == null) {
            clazz = ServiceMessage.class;
        }
        try {
            ServiceMessage msg = clazz.newInstance();
            msg.init(key, argumentsStr);
            return msg;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    protected String getAttributeValue(String attrName) {
        return this.getAttributes().get(attrName);
    }

    private String stringToText(@NotNull String message) throws ParseException {
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.stringToText must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of jetbrains/buildServer/messages/serviceMessages/ServiceMessage.stringToText must not be null");
        }
        if ((message = message.trim()).startsWith("'") && message.endsWith("'")) {
            return StringUtil.unescapeStr(message.substring(1, message.length() - 1), STD_ESCAPER);
        }
        throw new ParseException("Cannot extract text message [" + message + "]", 0);
    }

    static {
        myServiceMessageClasses.put("progressMessage", ProgressMessage.class);
        myServiceMessageClasses.put("progressStart", ProgressStart.class);
        myServiceMessageClasses.put("progressFinish", ProgressFinish.class);
        myServiceMessageClasses.put("publishArtifacts", PublishArtifacts.class);
        myServiceMessageClasses.put("testSuiteStarted", TestSuiteStarted.class);
        myServiceMessageClasses.put("testSuiteFinished", TestSuiteFinished.class);
        myServiceMessageClasses.put("testStarted", TestStarted.class);
        myServiceMessageClasses.put("testFailed", TestFailed.class);
        myServiceMessageClasses.put("testFinished", TestFinished.class);
        myServiceMessageClasses.put("testIgnored", TestIgnored.class);
        myServiceMessageClasses.put("testStdOut", TestStdOut.class);
        myServiceMessageClasses.put("testStdErr", TestStdErr.class);
        myServiceMessageClasses.put("buildStatus", BuildStatus.class);
        myServiceMessageClasses.put("buildNumber", BuildNumber.class);
        myServiceMessageClasses.put("buildStatisticValue", BuildStatisticValue.class);
        STD_ESCAPER = new StringUtil.EscapeInfoProvider(){

            public char escape(char c) {
                switch (c) {
                    case '\n': {
                        return 'n';
                    }
                    case '\r': {
                        return 'r';
                    }
                    case '|': {
                        return '|';
                    }
                    case '\'': {
                        return '\'';
                    }
                    case '[': {
                        return '[';
                    }
                    case ']': {
                        return ']';
                    }
                }
                return '\u0000';
            }

            public char unescape(char c) {
                switch (c) {
                    case 'n': {
                        return '\n';
                    }
                    case 'r': {
                        return '\r';
                    }
                    case '\'': {
                        return '\'';
                    }
                    case '|': {
                        return '|';
                    }
                    case '[': {
                        return '[';
                    }
                    case ']': {
                        return ']';
                    }
                }
                return '\u0000';
            }

            public char escapeCharacter() {
                return '|';
            }
        };
    }
}

