/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.concurrency.JobUtil;
import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.PropertiesBundle;
import com.intellij.lang.properties.PropertySuppressableInspectionBase;
import com.intellij.lang.properties.RemovePropertyLocalFix;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.PsiSearchHelper;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UnusedPropertyInspection
extends PropertySuppressableInspectionBase {
    @NotNull
    public String getDisplayName() {
        String string = PropertiesBundle.message("unused.property.inspection.display.name", new Object[0]);
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/UnusedPropertyInspection.getDisplayName must not return null");
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("UnusedProperty" == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/UnusedPropertyInspection.getShortName must not return null");
        }
        return "UnusedProperty";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProblemDescriptor[] checkFile(final @NotNull PsiFile file, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (file == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/UnusedPropertyInspection.checkFile must not be null");
        }
        if (manager == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/UnusedPropertyInspection.checkFile must not be null");
        }
        if (!(file instanceof PropertiesFile)) {
            return null;
        }
        List<Property> properties = ((PropertiesFile)file).getProperties();
        Module module = ModuleUtil.findModuleForPsiElement((PsiElement)file);
        if (module == null) {
            return null;
        }
        SmartList descriptors = new SmartList();
        final GlobalSearchScope searchScope = GlobalSearchScope.moduleWithDependentsScope((Module)module);
        final ProgressIndicator original = ProgressManager.getInstance().getProgressIndicator();
        JobUtil.invokeConcurrentlyUnderMyProgress(properties, (Processor)new Processor<Property>((List)descriptors){
            final /* synthetic */ List val$descriptors;
            {
                this.val$descriptors = list;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public boolean process(Property property) {
                PsiReference usage;
                String name;
                if (original != null) {
                    if (original.isCanceled()) {
                        return false;
                    }
                    original.setText(PropertiesBundle.message("searching.for.property.key.progress.text", property.getUnescapedKey()));
                }
                if ((name = property.getName()) == null) {
                    return true;
                }
                PsiSearchHelper.SearchCostResult cheapEnough = file.getManager().getSearchHelper().isCheapEnoughToSearch(name, searchScope, file, original);
                if (cheapEnough == PsiSearchHelper.SearchCostResult.TOO_MANY_OCCURRENCES) {
                    return true;
                }
                PsiReference psiReference = usage = cheapEnough == PsiSearchHelper.SearchCostResult.ZERO_OCCURRENCES ? null : (PsiReference)ReferencesSearch.search((PsiElement)property, (SearchScope)searchScope, (boolean)false).findFirst();
                if (usage != null) {
                    return true;
                }
                ASTNode propertyNode = property.getNode();
                assert (propertyNode != null);
                ASTNode[] nodes = propertyNode.getChildren(null);
                Property key = nodes.length == 0 ? property : nodes[0].getPsi();
                String description = PropertiesBundle.message("unused.property.problem.descriptor.name", new Object[0]);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)key, description, (LocalQuickFix)RemovePropertyLocalFix.INSTANCE, ProblemHighlightType.LIKE_UNUSED_SYMBOL, isOnTheFly);
                List list = this.val$descriptors;
                synchronized (list) {
                    this.val$descriptors.add(descriptor);
                }
                return true;
            }
        }, (String)"Searching properties usages");
        SmartList smartList = descriptors;
        synchronized (smartList) {
            return descriptors.toArray(new ProblemDescriptor[descriptors.size()]);
        }
    }
}

