/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesReferenceManager;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.lang.properties.psi.Property;
import com.intellij.lang.properties.psi.PropertyKeyIndex;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ResourceFileUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PropertiesUtil {
    private PropertiesUtil() {
    }

    @NotNull
    public static List<Property> findPropertiesByKey(Project project, String key) {
        ArrayList<Property> arrayList = new ArrayList<Property>(PropertyKeyIndex.getInstance().get(key, project, GlobalSearchScope.allScope((Project)project)));
        if (arrayList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesUtil.findPropertiesByKey must not return null");
        }
        return arrayList;
    }

    public static boolean isPropertyComplete(Project project, ResourceBundle resourceBundle, String propertyName) {
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles(project);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            if (propertiesFile.findPropertyByKey(propertyName) != null) continue;
            return false;
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @NotNull
    public static String getBaseName(@NotNull VirtualFile virtualFile) {
        String part;
        String string;
        if (virtualFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesUtil.getBaseName must not be null");
        }
        String name = virtualFile.getNameWithoutExtension();
        List parts = StringUtil.split((String)name, (String)"_");
        if (parts.size() == 1) {
            String string2 = (String)parts.get(0);
            string = string2;
            if (string2 != null) return string;
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesUtil.getBaseName must not return null");
        }
        if (parts.size() == 0) {
            return "";
        }
        String baseName = (String)parts.get(0);
        for (int i = 1; i < parts.size() && (part = (String)parts.get(i)).length() != 2; ++i) {
            baseName = baseName + "_";
            baseName = baseName + part;
        }
        String string3 = baseName;
        string = string3;
        if (string3 == null) throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesUtil.getBaseName must not return null");
        return string;
    }

    @Nullable
    public static PropertiesFile getParent(PropertiesFile file, List<PropertiesFile> candidates) {
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return null;
        }
        String name = virtualFile.getNameWithoutExtension();
        String[] parts = name.split("_");
        if (parts.length == 1) {
            return null;
        }
        List<String> partsList = Arrays.asList(parts);
        for (int i = parts.length - 1; i >= 1; --i) {
            String parentName = StringUtil.join(partsList.subList(0, i), (String)"_") + "." + virtualFile.getExtension();
            for (PropertiesFile candidate : candidates) {
                if (!parentName.equals(candidate.getName())) continue;
                return candidate;
            }
        }
        return null;
    }

    @Nullable
    public static String getFullName(final PropertiesFile psiFile) {
        return (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            public String compute() {
                PsiDirectory directory = psiFile.getParent();
                String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
                if (packageQualifiedName == null) {
                    return null;
                }
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                VirtualFile virtualFile = psiFile.getVirtualFile();
                assert (virtualFile != null);
                qName.append(PropertiesUtil.getBaseName(virtualFile));
                return qName.toString();
            }
        });
    }

    @NotNull
    public static Locale getLocale(VirtualFile propertiesFile) {
        String name = propertiesFile.getNameWithoutExtension();
        String tail = StringUtil.trimStart((String)name, (String)PropertiesUtil.getBaseName(propertiesFile));
        String[] parts = (tail = StringUtil.trimStart((String)tail, (String)"_")).split("_");
        String language = parts.length == 0 ? "" : parts[0];
        String country = "";
        String variant = "";
        if (parts.length >= 2 && parts[1].length() == 2) {
            country = parts[1];
            for (int i = 2; i < parts.length; ++i) {
                String part = parts[i];
                if (variant.length() != 0) {
                    variant = variant + "_";
                }
                variant = variant + part;
            }
        }
        Locale locale = new Locale(language, country, variant);
        if (locale == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesUtil.getLocale must not return null");
        }
        return locale;
    }

    @NotNull
    public static List<Property> findAllProperties(Project project, @NotNull ResourceBundle resourceBundle, String key) {
        if (resourceBundle == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/PropertiesUtil.findAllProperties must not be null");
        }
        SmartList result = new SmartList();
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles(project);
        for (PropertiesFile propertiesFile : propertiesFiles) {
            result.addAll(propertiesFile.findPropertiesByKey(key));
        }
        SmartList smartList = result;
        if (smartList == null) {
            throw new IllegalStateException("@NotNull method com/intellij/lang/properties/PropertiesUtil.findAllProperties must not return null");
        }
        return smartList;
    }

    public static boolean isUnescapedBackSlashAtTheEnd(String text) {
        boolean result = false;
        for (int i = text.length() - 1; i >= 0 && text.charAt(i) == '\\'; --i) {
            result = !result;
        }
        return result;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(String bundleName, Module searchFromModule) {
        PsiFile psiFile;
        String fileName = bundleName + ".properties";
        VirtualFile vFile = ResourceFileUtil.findResourceFileInDependents((Module)searchFromModule, (String)fileName);
        if (vFile != null && (psiFile = PsiManager.getInstance((Project)searchFromModule.getProject()).findFile(vFile)) instanceof PropertiesFile) {
            return (PropertiesFile)psiFile;
        }
        return null;
    }

    @Nullable
    public static PropertiesFile getPropertiesFile(@NotNull String bundleName, @NotNull Module searchFromModule, @Nullable Locale locale) {
        if (bundleName == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/properties/PropertiesUtil.getPropertiesFile must not be null");
        }
        if (searchFromModule == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/properties/PropertiesUtil.getPropertiesFile must not be null");
        }
        PropertiesReferenceManager manager = PropertiesReferenceManager.getInstance(searchFromModule.getProject());
        return manager.findPropertiesFile(searchFromModule, bundleName, locale);
    }

    public static String getPackageQualifiedName(PsiDirectory directory) {
        return ProjectRootManager.getInstance((Project)directory.getProject()).getFileIndex().getPackageNameByDirectory(directory.getVirtualFile());
    }
}

