/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.documentation.QuickDocumentationProvider;
import com.intellij.lang.properties.PropertiesHighlighter;
import com.intellij.lang.properties.psi.Property;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.GuiUtils;
import java.awt.Color;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class PropertiesDocumentationProvider
extends QuickDocumentationProvider {
    @Nullable
    public String getQuickNavigateInfo(PsiElement element) {
        if (element instanceof Property) {
            String info = "\n\"" + ((Property)element).getValue() + "\"";
            PsiFile file = element.getContainingFile();
            if (file != null) {
                info = info + " [" + file.getName() + "]";
            }
            return info;
        }
        return null;
    }

    public String generateDoc(PsiElement element, PsiElement originalElement) {
        if (element instanceof Property) {
            Property property = (Property)element;
            String text = property.getDocCommentText();
            String info = "";
            if (text != null) {
                TextAttributes attributes = EditorColorsManager.getInstance().getGlobalScheme().getAttributes(PropertiesHighlighter.PROPERTY_COMMENT).clone();
                Color background = attributes.getBackgroundColor();
                if (background != null) {
                    info = info + "<div bgcolor=#" + GuiUtils.colorToHex((Color)background) + ">";
                }
                String doc = StringUtil.join((Collection)StringUtil.split((String)text, (String)"\n"), (String)"<br>");
                info = info + "<font color=#" + GuiUtils.colorToHex((Color)attributes.getForegroundColor()) + ">" + doc + "</font>\n<br>";
                if (background != null) {
                    info = info + "</div>";
                }
            }
            info = info + "\n<b>" + property.getName() + "</b>=\"" + ((Property)element).getValue() + "\"";
            PsiFile file = element.getContainingFile();
            if (file != null) {
                info = info + " [" + file.getName() + "]";
            }
            return info;
        }
        return null;
    }
}

