/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties;

import com.intellij.lang.properties.PropertiesUtil;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.Nullable;

public interface BundleNameEvaluator {
    public static final BundleNameEvaluator DEFAULT = new BundleNameEvaluator(){

        @Override
        @Nullable
        public String evaluateBundleName(PsiFile psiFile) {
            VirtualFile virtualFile;
            VirtualFile virtualFile2 = virtualFile = psiFile == null ? null : psiFile.getOriginalFile().getVirtualFile();
            if (virtualFile == null || !(psiFile instanceof PropertiesFile)) {
                return null;
            }
            PsiDirectory directory = psiFile.getParent();
            String packageQualifiedName = PropertiesUtil.getPackageQualifiedName(directory);
            if (packageQualifiedName != null) {
                StringBuilder qName = new StringBuilder(packageQualifiedName);
                if (qName.length() > 0) {
                    qName.append(".");
                }
                qName.append(PropertiesUtil.getBaseName(virtualFile));
                return qName.toString();
            }
            return null;
        }
    };

    @Nullable
    public String evaluateBundleName(PsiFile var1);
}

