/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.util;

public class StringUtil {
    private StringUtil() {
    }

    public static boolean isEmpty(String s) {
        return s == null || s.trim().length() == 0;
    }

    public static boolean isNotEmpty(String s) {
        return !StringUtil.isEmpty(s);
    }

    public static boolean isLowerCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isLowerCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean isUpperCase(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (Character.isUpperCase(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasUpperCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isUpperCase(c)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasLowerCaseChar(String s) {
        char[] chars;
        for (char c : chars = s.toCharArray()) {
            if (!Character.isLowerCase(c)) continue;
            return true;
        }
        return false;
    }

    public static String after(String s, String token) {
        if (s == null) {
            return null;
        }
        int i = s.indexOf(token);
        if (i == -1) {
            return s;
        }
        return s.substring(i + token.length());
    }

    public static String before(String s, String token) {
        if (s == null) {
            return null;
        }
        int i = s.indexOf(token);
        if (i == -1) {
            return s;
        }
        return s.substring(0, i);
    }

    public static String middle(String s, String before, String after) {
        String first = StringUtil.after(s, before);
        return StringUtil.before(first, after);
    }

    public static String firstLetterToLowerCase(String s) {
        if (s.length() > 1) {
            return Character.toLowerCase(s.charAt(0)) + s.substring(1);
        }
        if (s.length() == 1) {
            return String.valueOf(Character.toLowerCase(s.charAt(0)));
        }
        return s;
    }

    public static String fixLineBreaks(String s) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if ('\r' == c) continue;
            sb.append(c);
        }
        return sb.toString();
    }
}

