/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.element;

import java.io.Serializable;
import org.jetbrains.generate.tostring.config.FilterPattern;
import org.jetbrains.generate.tostring.config.Filterable;
import org.jetbrains.generate.tostring.element.AbstractElement;
import org.jetbrains.generate.tostring.element.Element;
import org.jetbrains.generate.tostring.util.StringUtil;

public class FieldElement
extends AbstractElement
implements Serializable,
Element,
Filterable {
    private boolean isConstant;
    private boolean isEnum;
    private boolean isModifierTransient;
    private boolean isModifierVolatile;

    @Override
    public String getAccessor() {
        return this.name;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    public boolean isModifierTransient() {
        return this.isModifierTransient;
    }

    public boolean isModifierVolatile() {
        return this.isModifierVolatile;
    }

    public boolean isEnum() {
        return this.isEnum;
    }

    void setConstant(boolean constant) {
        this.isConstant = constant;
    }

    void setModifierTransient(boolean modifierTransient) {
        this.isModifierTransient = modifierTransient;
    }

    void setModifierVolatile(boolean modifierVolatile) {
        this.isModifierVolatile = modifierVolatile;
    }

    public void setEnum(boolean anEnum) {
        this.isEnum = anEnum;
    }

    public boolean matchName(String regexp) throws IllegalArgumentException {
        if (StringUtil.isEmpty(regexp)) {
            throw new IllegalArgumentException("Can't perform regular expression since the given input is empty. Check the Method body velocity code: regexp='" + regexp + "'");
        }
        return this.name.matches(regexp);
    }

    @Override
    public boolean applyFilter(FilterPattern pattern) {
        String type;
        if (pattern == null) {
            return false;
        }
        if (pattern.isConstantField() && this.isConstant) {
            return true;
        }
        if (pattern.isEnumField() && this.isEnum) {
            return true;
        }
        if (pattern.isStaticModifier() && this.isModifierStatic) {
            return true;
        }
        if (pattern.isTransientModifier() && this.isModifierTransient) {
            return true;
        }
        if (StringUtil.isNotEmpty(pattern.getFieldName()) && this.name.matches(pattern.getFieldName())) {
            return true;
        }
        if (StringUtil.isNotEmpty(pattern.getFieldType()) && !this.isPrimitive && this.getTypeQualifiedName() != null && (type = this.getTypeQualifiedName()).matches(pattern.getFieldType())) {
            return true;
        }
        return pattern.isLoggers() && !this.isPrimitive && ("org.apache.log4j.Logger".equals(this.getTypeQualifiedName()) || "java.util.logging.Logger".equals(this.getTypeQualifiedName()) || "org.apache.commons.logging.Log".equals(this.getTypeQualifiedName()));
    }

    @Override
    public String toString() {
        return super.toString() + " ::: FieldElement{" + "isConstant=" + this.isConstant + ", isEnum=" + this.isEnum + ", isModifierTransient=" + this.isModifierTransient + ", isModifierVolatile=" + this.isModifierVolatile + "}";
    }
}

