/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.generate.tostring.config;

import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiMethod;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.generate.tostring.config.InsertNewMethodStrategy;
import org.jetbrains.generate.tostring.psi.PsiAdapter;
import org.jetbrains.generate.tostring.psi.PsiAdapterFactory;

public class InsertLastStrategy
implements InsertNewMethodStrategy {
    private static final InsertLastStrategy instance = new InsertLastStrategy();

    private InsertLastStrategy() {
    }

    public static InsertLastStrategy getInstance() {
        return instance;
    }

    @Override
    public PsiMethod insertNewMethod(PsiClass clazz, @NotNull PsiMethod newMethod, Editor editor) throws IncorrectOperationException {
        PsiMethod[] methods;
        if (newMethod == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of org/jetbrains/generate/tostring/config/InsertLastStrategy.insertNewMethod must not be null");
        }
        PsiAdapter psi = PsiAdapterFactory.getPsiAdapter();
        PsiMethod mainMethod = psi.findPublicStaticVoidMainMethod(clazz);
        if (mainMethod != null && mainMethod.equals((methods = clazz.getMethods())[methods.length - 1])) {
            return (PsiMethod)clazz.addBefore((PsiElement)newMethod, (PsiElement)mainMethod);
        }
        PsiJavaToken last = clazz.getRBrace();
        return (PsiMethod)clazz.addBefore((PsiElement)newMethod, (PsiElement)last);
    }

    public String toString() {
        return "Last";
    }
}

