/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xdebugger;

import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.execution.ui.RunnerLayoutUi;
import com.intellij.xdebugger.DefaultDebugProcessHandler;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerBundle;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpointHandler;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.stepping.XSmartStepIntoHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class XDebugProcess {
    private final XDebugSession mySession;
    private ProcessHandler myProcessHandler;

    protected XDebugProcess(@NotNull XDebugSession session) {
        if (session == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/XDebugProcess.<init> must not be null");
        }
        this.mySession = session;
    }

    public final XDebugSession getSession() {
        return this.mySession;
    }

    public XBreakpointHandler<?>[] getBreakpointHandlers() {
        return XBreakpointHandler.EMPTY_ARRAY;
    }

    @Nullable
    public XDebuggerEditorsProvider getEditorsProvider() {
        return null;
    }

    public void sessionInitialized() {
    }

    public void startPausing() {
    }

    public abstract void startStepOver();

    public abstract void startStepInto();

    public abstract void startStepOut();

    @Nullable
    public XSmartStepIntoHandler<?> getSmartStepIntoHandler() {
        return null;
    }

    public abstract void stop();

    public abstract void resume();

    public abstract void runToPosition(@NotNull XSourcePosition var1);

    @Nullable
    protected ProcessHandler doGetProcessHandler() {
        return null;
    }

    @NotNull
    public final ProcessHandler getProcessHandler() {
        if (this.myProcessHandler == null) {
            this.myProcessHandler = this.doGetProcessHandler();
            if (this.myProcessHandler == null) {
                this.myProcessHandler = new DefaultDebugProcessHandler();
            }
        }
        ProcessHandler processHandler = this.myProcessHandler;
        if (processHandler == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/XDebugProcess.getProcessHandler must not return null");
        }
        return processHandler;
    }

    @NotNull
    public ExecutionConsole createConsole() {
        TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(this.getSession().getProject());
        ConsoleView consoleView = consoleBuilder.getConsole();
        if (consoleView == null) {
            throw new IllegalStateException("@NotNull method com/intellij/xdebugger/XDebugProcess.createConsole must not return null");
        }
        return consoleView;
    }

    public void registerAdditionalContent(@NotNull RunnerLayoutUi ui) {
        if (ui == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/xdebugger/XDebugProcess.registerAdditionalContent must not be null");
        }
    }

    public String getCurrentStateMessage() {
        return this.mySession.isStopped() ? XDebuggerBundle.message("debugger.state.message.disconnected", new Object[0]) : XDebuggerBundle.message("debugger.state.message.connected", new Object[0]);
    }
}

