/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.ui;

import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Factory;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.AbstractConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.NamedEnumUtil;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.highlighting.DomElementProblemDescriptor;
import com.intellij.util.xml.highlighting.DomElementsProblemsHolder;
import com.intellij.util.xml.ui.BaseModifiableControl;
import com.intellij.util.xml.ui.DomStringWrapper;
import com.intellij.util.xml.ui.DomWrapper;
import com.intellij.util.xml.ui.TooltipUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.swing.DefaultListCellRenderer;
import javax.swing.Icon;
import javax.swing.JComboBox;
import javax.swing.JList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboControl
extends BaseModifiableControl<JComboBox, String> {
    private static final Pair<String, Icon> EMPTY = new ComboBoxItem(" ", null);
    private final Factory<List<Pair<String, Icon>>> myDataFactory;
    private boolean myNullable;
    private final Map<String, Icon> myIcons = new HashMap<String, Icon>();
    private final ItemListener myCommitListener = new ItemListener(){

        @Override
        public void itemStateChanged(ItemEvent e) {
            ComboControl.this.setModified();
            ComboControl.this.commit();
        }
    };

    public ComboControl(GenericDomValue genericDomValue, Factory<List<Pair<String, Icon>>> dataFactory) {
        this((DomWrapper<String>)new DomStringWrapper(genericDomValue), dataFactory);
    }

    public ComboControl(DomWrapper<String> domWrapper, Factory<List<Pair<String, Icon>>> dataFactory) {
        super(domWrapper);
        this.myDataFactory = dataFactory;
        this.reset();
    }

    public ComboControl(DomWrapper<String> domWrapper, Class<? extends Enum> aClass) {
        super(domWrapper);
        this.myDataFactory = ComboControl.createEnumFactory(aClass);
        this.reset();
    }

    public final boolean isNullable() {
        return this.myNullable;
    }

    public final void setNullable(boolean nullable) {
        this.myNullable = nullable;
    }

    public ComboControl(GenericDomValue<?> reference) {
        this(reference, ComboControl.createResolvingFunction(reference));
    }

    public static Factory<List<Pair<String, Icon>>> createResolvingFunction(final GenericDomValue<?> reference) {
        return new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                Converter converter = reference.getConverter();
                if (converter instanceof ResolvingConverter) {
                    AbstractConvertContext context = new AbstractConvertContext(){

                        @Override
                        @NotNull
                        public DomElement getInvocationElement() {
                            GenericDomValue genericDomValue = reference;
                            if (genericDomValue == null) {
                                throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/ComboControl$2$1.getInvocationElement must not return null");
                            }
                            return genericDomValue;
                        }
                    };
                    ResolvingConverter resolvingConverter = (ResolvingConverter)converter;
                    Collection variants = resolvingConverter.getVariants(context);
                    List all = ContainerUtil.map(variants, (Function)new Function<Object, Pair<String, Icon>>(){

                        public Pair<String, Icon> fun(Object s) {
                            return Pair.create((Object)ElementPresentationManager.getElementName(s), (Object)ElementPresentationManager.getIcon(s));
                        }
                    });
                    all.addAll(ContainerUtil.map(resolvingConverter.getAdditionalVariants(context), (Function)new Function(){

                        public Object fun(Object s) {
                            return new Pair(s, null);
                        }
                    }));
                    return all;
                }
                return Collections.emptyList();
            }
        };
    }

    public static Factory<Collection<? extends Object>> createVariantsGetter(final GenericDomValue<?> reference) {
        return new Factory<Collection<? extends Object>>(){

            public Collection<? extends Object> create() {
                Converter converter = reference.getConverter();
                if (converter instanceof ResolvingConverter) {
                    return ((ResolvingConverter)converter).getVariants(new AbstractConvertContext(){

                        @Override
                        @NotNull
                        public DomElement getInvocationElement() {
                            GenericDomValue genericDomValue = reference;
                            if (genericDomValue == null) {
                                throw new IllegalStateException("@NotNull method com/intellij/util/xml/ui/ComboControl$3$1.getInvocationElement must not return null");
                            }
                            return genericDomValue;
                        }
                    });
                }
                return Collections.emptyList();
            }
        };
    }

    public static Factory<List<Pair<String, Icon>>> createPresentationFunction(final Factory<Collection<? extends Object>> variantFactory) {
        return new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map((Iterable)((Iterable)variantFactory.create()), (Function)new Function<Object, Pair<String, Icon>>(){

                    public Pair<String, Icon> fun(Object s) {
                        return Pair.create((Object)ElementPresentationManager.getElementName(s), (Object)ElementPresentationManager.getIcon(s));
                    }
                });
            }
        };
    }

    static Factory<List<Pair<String, Icon>>> createEnumFactory(final Class<? extends Enum> aClass) {
        return new Factory<List<Pair<String, Icon>>>(){

            public List<Pair<String, Icon>> create() {
                return ContainerUtil.map2List((Object[])aClass.getEnumConstants(), (Function)new Function<Enum, Pair<String, Icon>>(){

                    public Pair<String, Icon> fun(Enum s) {
                        return Pair.create((Object)NamedEnumUtil.getEnumValueByElement(s), (Object)ElementPresentationManager.getIcon(s));
                    }
                });
            }
        };
    }

    public static <T extends Enum> JComboBox createEnumComboBox(Class<T> type) {
        return ComboControl.tuneUpComboBox(new JComboBox(), ComboControl.createEnumFactory(type));
    }

    private static JComboBox tuneUpComboBox(JComboBox comboBox, Factory<List<Pair<String, Icon>>> dataFactory) {
        List list = (List)dataFactory.create();
        final HashSet<Object> standardValues = new HashSet<Object>();
        for (Pair pair : list) {
            comboBox.addItem(new ComboBoxItem((Pair<String, Icon>)pair));
            standardValues.add(pair.first);
        }
        return ComboControl.initComboBox(comboBox, new Condition<String>(){

            public boolean value(String object) {
                return standardValues.contains(object);
            }
        });
    }

    static JComboBox initComboBox(JComboBox comboBox, final Condition<String> validity) {
        comboBox.setEditable(false);
        comboBox.setPrototypeDisplayValue(new ComboBoxItem("A", null));
        comboBox.setRenderer(new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, cellHasFocus);
                Pair pair = (Pair)value;
                String text = pair == null ? null : (String)pair.first;
                this.setText(text);
                Dimension dimension = this.getPreferredSize();
                if (!validity.value((Object)text)) {
                    this.setFont(this.getFont().deriveFont(2));
                    this.setForeground(Color.RED);
                }
                this.setIcon(pair == null ? null : (Icon)pair.second);
                this.setPreferredSize(new Dimension(-1, dimension.height));
                return this;
            }
        });
        return comboBox;
    }

    @Override
    protected JComboBox createMainComponent(JComboBox boundedComponent) {
        return ComboControl.initComboBox(boundedComponent == null ? new JComboBox() : boundedComponent, new Condition<String>(){

            public boolean value(String object) {
                return ComboControl.this.isValidValue(object);
            }
        });
    }

    public boolean isValidValue(String object) {
        return this.myNullable && object == ComboControl.EMPTY.first || this.myIcons.containsKey(object);
    }

    private boolean dataChanged(List<Pair<String, Icon>> newData) {
        JComboBox comboBox = (JComboBox)this.getComponent();
        int size = comboBox.getItemCount();
        ArrayList<Pair> oldData = new ArrayList<Pair>(size);
        for (int i = 0; i < size; ++i) {
            oldData.add((Pair)comboBox.getItemAt(i));
        }
        if (this.myNullable) {
            LinkedList<Pair<String, Icon>> list = new LinkedList<Pair<String, Icon>>(newData);
            list.addFirst(EMPTY);
            newData = list;
        }
        return !((Object)newData).equals(oldData);
    }

    @Override
    protected boolean isCommitted() {
        return ((JComboBox)this.getComponent()).isPopupVisible() || super.isCommitted();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doReset() {
        List data = (List)this.myDataFactory.create();
        JComboBox comboBox = (JComboBox)this.getComponent();
        comboBox.removeItemListener(this.myCommitListener);
        try {
            if (!this.dataChanged(data)) {
                super.doReset();
                return;
            }
            String oldValue = this.getValue();
            this.myIcons.clear();
            comboBox.removeAllItems();
            if (this.myNullable) {
                comboBox.addItem(EMPTY);
            }
            for (Pair s : data) {
                comboBox.addItem(new ComboBoxItem((Pair<String, Icon>)s));
                this.myIcons.put((String)s.first, (Icon)s.second);
            }
            this.setValue(oldValue);
            super.doReset();
        }
        finally {
            comboBox.addItemListener(this.myCommitListener);
        }
    }

    @Override
    @Nullable
    protected final String getValue() {
        Pair pair = (Pair)((JComboBox)this.getComponent()).getSelectedItem();
        return pair == null || pair == EMPTY ? null : (String)pair.first;
    }

    @Override
    protected final void setValue(String value) {
        JComboBox component = (JComboBox)this.getComponent();
        if (!this.isValidValue(value)) {
            component.setEditable(true);
        }
        component.setSelectedItem((Object)new ComboBoxItem(value, this.myIcons.get(value)));
        component.setEditable(false);
    }

    @Override
    protected void updateComponent() {
        DomElement domElement = this.getDomElement();
        if (domElement == null || !domElement.isValid()) {
            return;
        }
        final JComboBox comboBox = (JComboBox)this.getComponent();
        final Project project = this.getProject();
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                if (!project.isOpen()) {
                    return;
                }
                if (!ComboControl.this.getDomWrapper().isValid()) {
                    return;
                }
                DomElement domElement = ComboControl.this.getDomElement();
                if (domElement == null || !domElement.isValid()) {
                    return;
                }
                DomElementAnnotationsManager manager = DomElementAnnotationsManager.getInstance(project);
                DomElementsProblemsHolder holder = manager.getCachedProblemHolder(domElement);
                List<DomElementProblemDescriptor> errorProblems = holder.getProblems(domElement);
                List<DomElementProblemDescriptor> warningProblems = holder.getProblems(domElement, true, HighlightSeverity.WARNING);
                Color background = ComboControl.this.getDefaultBackground();
                comboBox.setToolTipText(null);
                if (errorProblems.size() > 0) {
                    background = ComboControl.this.getErrorBackground();
                    comboBox.setToolTipText(TooltipUtils.getTooltipText(errorProblems));
                } else if (warningProblems.size() > 0) {
                    background = ComboControl.this.getWarningBackground();
                    comboBox.setToolTipText(TooltipUtils.getTooltipText(warningProblems));
                }
                Pair pair = (Pair)comboBox.getSelectedItem();
                String s = pair == null ? null : (String)pair.first;
                background = s != null && s.trim().length() > 0 ? ComboControl.this.getDefaultBackground() : background;
                comboBox.setBackground(background);
                comboBox.getEditor().getEditorComponent().setBackground(background);
            }
        });
    }

    private static class ComboBoxItem
    extends Pair<String, Icon> {
        public ComboBoxItem(String first, Icon second) {
            super((Object)first, (Object)second);
        }

        public ComboBoxItem(Pair<String, Icon> pair) {
            super(pair.first, pair.second);
        }

        public String toString() {
            return (String)this.first;
        }
    }
}

