/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.model.impl;

import com.intellij.psi.xml.XmlFile;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.ModelMerger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomModelFactoryHelper<T extends DomElement> {
    protected final Class<T> myClass;
    protected final ModelMerger myModelMerger;

    public DomModelFactoryHelper(@NotNull Class<T> aClass, @NotNull ModelMerger modelMerger) {
        if (aClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelFactoryHelper.<init> must not be null");
        }
        if (modelMerger == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelFactoryHelper.<init> must not be null");
        }
        this.myClass = aClass;
        this.myModelMerger = modelMerger;
    }

    @Nullable
    public T getDom(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelFactoryHelper.getDom must not be null");
        }
        DomFileElement<T> element = this.getDomRoot(configFile);
        return element == null ? null : (T)element.getRootElement();
    }

    @Nullable
    public DomFileElement<T> getDomRoot(@NotNull XmlFile configFile) {
        if (configFile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/util/xml/model/impl/DomModelFactoryHelper.getDomRoot must not be null");
        }
        return DomManager.getDomManager(configFile.getProject()).getFileElement(configFile, this.myClass);
    }

    public Class<T> getDomModelClass() {
        return this.myClass;
    }

    public ModelMerger getModelMerger() {
        return this.myModelMerger;
    }
}

