/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.update;

import com.intellij.ide.DataManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LazyUiDisposable<T extends Disposable>
implements Activatable {
    private Throwable myAllocation;
    private boolean myWasEverShown;
    private Disposable myParent;
    private T myChild;
    private Project myProject;

    public LazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, @NotNull T child) {
        if (ui == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/update/LazyUiDisposable.<init> must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ui/update/LazyUiDisposable.<init> must not be null");
        }
        this(parent, ui, child, null);
    }

    public LazyUiDisposable(@Nullable Disposable parent, @NotNull JComponent ui, @NotNull T child, @Nullable Project project) {
        if (ui == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/util/ui/update/LazyUiDisposable.<init> must not be null");
        }
        if (child == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/util/ui/update/LazyUiDisposable.<init> must not be null");
        }
        if (Boolean.TRUE.toString().equalsIgnoreCase(System.getProperty("idea.is.internal"))) {
            this.myAllocation = new Exception();
        }
        this.myParent = parent;
        this.myChild = child;
        this.myProject = project;
        new UiNotifyConnector.Once(ui, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void showNotify() {
        if (this.myWasEverShown) {
            return;
        }
        try {
            Disposable parent = this.findParentDisposable();
            this.initialize(parent, this.myChild, this.findProject());
            Disposer.register((Disposable)parent, this.myChild);
        }
        finally {
            this.myWasEverShown = true;
        }
    }

    @Override
    public final void hideNotify() {
    }

    protected abstract void initialize(@NotNull Disposable var1, @NotNull T var2, @Nullable Project var3);

    @NotNull
    private Disposable findParentDisposable() {
        Disposable parent = this.findObject(this.myParent, PlatformDataKeys.UI_DISPOSABLE);
        Disposable disposable = parent != null ? parent : Disposer.get((String)"ui");
        if (disposable == null) {
            throw new IllegalStateException("@NotNull method com/intellij/util/ui/update/LazyUiDisposable.findParentDisposable must not return null");
        }
        return disposable;
    }

    @Nullable
    private Project findProject() {
        return (Project)this.findObject(this.myProject, PlatformDataKeys.PROJECT);
    }

    private Disposable findObject(Disposable defaultValue, DataKey<? extends Disposable> key) {
        if (defaultValue == null) {
            if (ApplicationManager.getApplication() != null) {
                return key.getData(DataManager.getInstance().getDataContext());
            }
            return null;
        }
        return defaultValue;
    }
}

