/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages.impl.rules;

import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiUtilBase;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageGroup;
import com.intellij.usages.UsageView;
import com.intellij.usages.rules.PsiElementUsage;
import com.intellij.usages.rules.UsageGroupingRule;
import com.intellij.util.Icons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;

public class UsageScopeGroupingRule
implements UsageGroupingRule {
    private static final UsageScopeGroup TEST = new UsageScopeGroup(true);
    private static final UsageScopeGroup PRODUCTION = new UsageScopeGroup(false);

    @Override
    public UsageGroup groupUsage(Usage usage) {
        if (!(usage instanceof PsiElementUsage)) {
            return null;
        }
        PsiElementUsage elementUsage = (PsiElementUsage)usage;
        PsiElement element = elementUsage.getElement();
        VirtualFile virtualFile = PsiUtilBase.getVirtualFile(element);
        if (virtualFile == null) {
            return null;
        }
        boolean isInTest = ProjectRootManager.getInstance(element.getProject()).getFileIndex().isInTestSourceContent(virtualFile);
        return isInTest ? TEST : PRODUCTION;
    }

    private static class UsageScopeGroup
    implements UsageGroup {
        private final boolean isTest;

        private UsageScopeGroup(boolean isTest) {
            this.isTest = isTest;
        }

        @Override
        public void update() {
        }

        @Override
        public Icon getIcon(boolean isOpen) {
            return this.isTest ? Icons.TEST_SOURCE_FOLDER : Icons.SOURCE_FOLDERS_ICON;
        }

        @Override
        @NotNull
        public String getText(UsageView view) {
            String string = this.isTest ? "Test" : "Production";
            if (string == null) {
                throw new IllegalStateException("@NotNull method com/intellij/usages/impl/rules/UsageScopeGroupingRule$UsageScopeGroup.getText must not return null");
            }
            return string;
        }

        @Override
        public FileStatus getFileStatus() {
            return null;
        }

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void navigate(boolean focus) {
        }

        @Override
        public boolean canNavigate() {
            return false;
        }

        @Override
        public boolean canNavigateToSource() {
            return false;
        }

        @Override
        public int compareTo(UsageGroup usageGroup) {
            return this.getText(null).compareTo(usageGroup.getText(null));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof UsageScopeGroup)) {
                return false;
            }
            UsageScopeGroup usageTypeGroup = (UsageScopeGroup)o;
            return this.isTest == usageTypeGroup.isTest;
        }

        public int hashCode() {
            return this.isTest ? 0 : 1;
        }
    }
}

