/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.usages;

import com.intellij.codeInsight.highlighting.ReadWriteAccessDetector;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.usageView.UsageInfo;
import com.intellij.usages.ReadWriteAccessUsageInfo2UsageAdapter;
import com.intellij.usages.Usage;
import com.intellij.usages.UsageConvertor;
import com.intellij.usages.UsageInfo2UsageAdapter;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class UsageInfoToUsageConverter {
    private UsageInfoToUsageConverter() {
    }

    @NotNull
    public static Usage convert(TargetElementsDescriptor descriptor, UsageInfo usageInfo) {
        UsageConvertor[] convertors;
        Usage usage = UsageInfoToUsageConverter._convert(descriptor, usageInfo);
        for (UsageConvertor convertor : convertors = ApplicationManager.getApplication().getComponents(UsageConvertor.class)) {
            usage = convertor.convert(usage);
        }
        Usage usage2 = usage;
        if (usage2 == null) {
            throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter.convert must not return null");
        }
        return usage2;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    private static Usage _convert(TargetElementsDescriptor descriptor, UsageInfo usageInfo) {
        UsageInfo2UsageAdapter usageInfo2UsageAdapter;
        PsiElement[] primaryElements = descriptor.getPrimaryElements();
        for (ReadWriteAccessDetector detector : (ReadWriteAccessDetector[])Extensions.getExtensions(ReadWriteAccessDetector.EP_NAME)) {
            if (!UsageInfoToUsageConverter.isReadWriteAccessibleElements(primaryElements, detector)) continue;
            PsiElement usageElement = usageInfo.getElement();
            ReadWriteAccessDetector.Access rwAccess = detector.getExpressionAccess(usageElement);
            usageInfo2UsageAdapter = new ReadWriteAccessUsageInfo2UsageAdapter(usageInfo, rwAccess != ReadWriteAccessDetector.Access.Write, rwAccess != ReadWriteAccessDetector.Access.Read);
            if (usageInfo2UsageAdapter == null) throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter._convert must not return null");
            return usageInfo2UsageAdapter;
        }
        usageInfo2UsageAdapter = new UsageInfo2UsageAdapter(usageInfo);
        if (usageInfo2UsageAdapter != null) return usageInfo2UsageAdapter;
        throw new IllegalStateException("@NotNull method com/intellij/usages/UsageInfoToUsageConverter._convert must not return null");
    }

    public static Usage[] convert(TargetElementsDescriptor descriptor, UsageInfo[] usageInfos) {
        Usage[] usages = new Usage[usageInfos.length];
        for (int i = 0; i < usages.length; ++i) {
            usages[i] = UsageInfoToUsageConverter.convert(descriptor, usageInfos[i]);
        }
        return usages;
    }

    private static boolean isReadWriteAccessibleElements(PsiElement[] elements, ReadWriteAccessDetector detector) {
        if (elements.length == 0) {
            return false;
        }
        for (PsiElement element : elements) {
            if (detector.isReadWriteAccessible(element)) continue;
            return false;
        }
        return true;
    }

    public static class TargetElementsDescriptor {
        private final List<SmartPsiElementPointer> myPrimarySearchedElements;
        private final List<SmartPsiElementPointer> myAdditionalSearchedElements;
        private static final Function<SmartPsiElementPointer, PsiElement> SMARTPOINTER_TO_ELEMENT_MAPPER = new Function<SmartPsiElementPointer, PsiElement>(){

            public PsiElement fun(SmartPsiElementPointer s) {
                return s.getElement();
            }
        };

        public TargetElementsDescriptor(PsiElement element) {
            this(new PsiElement[]{element});
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements) {
            this(primarySearchedElements, PsiElement.EMPTY_ARRAY);
        }

        public TargetElementsDescriptor(PsiElement[] primarySearchedElements, PsiElement[] additionalSearchedElements) {
            this.myPrimarySearchedElements = TargetElementsDescriptor.convertToSmartPointers(primarySearchedElements);
            this.myAdditionalSearchedElements = TargetElementsDescriptor.convertToSmartPointers(additionalSearchedElements);
        }

        private static PsiElement[] convertToPsiElements(List<SmartPsiElementPointer> primary) {
            return (PsiElement[])ContainerUtil.map2Array(primary, PsiElement.class, SMARTPOINTER_TO_ELEMENT_MAPPER);
        }

        private static List<SmartPsiElementPointer> convertToSmartPointers(PsiElement[] primaryElements) {
            return primaryElements != null ? ContainerUtil.mapNotNull((Object[])primaryElements, (Function)new Function<PsiElement, SmartPsiElementPointer>(){

                public SmartPsiElementPointer fun(PsiElement s) {
                    return SmartPointerManager.getInstance(s.getProject()).createSmartPsiElementPointer(s);
                }
            }) : Collections.emptyList();
        }

        public PsiElement[] getPrimaryElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myPrimarySearchedElements);
        }

        public PsiElement[] getAdditionalElements() {
            return TargetElementsDescriptor.convertToPsiElements(this.myAdditionalSearchedElements);
        }

        public List<? extends PsiElement> getAllElements() {
            Object element;
            ArrayList result = new ArrayList(this.myPrimarySearchedElements.size() + this.myAdditionalSearchedElements.size());
            for (SmartPsiElementPointer pointer : this.myPrimarySearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            for (SmartPsiElementPointer pointer : this.myAdditionalSearchedElements) {
                element = pointer.getElement();
                if (element == null) continue;
                result.add(element);
            }
            return result;
        }
    }
}

