/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tabs.impl.singleRow;

import com.intellij.openapi.ui.popup.ActiveIcon;
import com.intellij.openapi.util.IconLoader;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;

public abstract class MoreIcon {
    private final ActiveIcon myLeft = new ActiveIcon(IconLoader.getIcon((String)"/general/comboArrowLeft.png"), IconLoader.getIcon((String)"/general/comboArrowLeftPassive.png"));
    private final ActiveIcon myRight = new ActiveIcon(IconLoader.getIcon((String)"/general/comboArrowRight.png"), IconLoader.getIcon((String)"/general/comboArrowRightPassive.png"));
    private final int myGap = 2;
    private boolean myLeftPainted;
    private boolean myRightPainted;

    public void paintIcon(Component c, Graphics g) {
        this.myLeft.setActive(this.isActive());
        this.myRight.setActive(this.isActive());
        Rectangle moreRect = this.getIconRec();
        if (moreRect == null) {
            return;
        }
        int iconY = this.getIconY(moreRect);
        int iconX = this.getIconX(moreRect);
        if (this.myLeftPainted && this.myRightPainted) {
            this.myLeft.paintIcon(c, g, iconX, iconY);
            this.myRight.paintIcon(c, g, iconX + this.myLeft.getIconWidth() + 2, iconY);
        } else {
            ActiveIcon toPaint;
            ActiveIcon activeIcon = this.myLeftPainted ? this.myLeft : (toPaint = this.myRightPainted ? this.myRight : null);
            if (toPaint != null) {
                toPaint.paintIcon(c, g, iconX + this.getIconWidth() / 2 - 2 - 1, iconY);
            }
        }
    }

    protected int getIconX(Rectangle iconRec) {
        return iconRec.x + iconRec.width / 2 - this.getIconWidth() / 2;
    }

    protected int getIconY(Rectangle iconRec) {
        return iconRec.y + iconRec.height / 2 - this.getIconHeight() / 2;
    }

    protected abstract boolean isActive();

    protected abstract Rectangle getIconRec();

    public void setPaintedIcons(boolean left, boolean right) {
        this.myLeftPainted = left;
        this.myRightPainted = right;
    }

    public int getIconWidth() {
        return this.myLeft.getIconWidth() + this.myRight.getIconWidth() + 2;
    }

    public int getIconHeight() {
        return this.myLeft.getIconHeight();
    }
}

