/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import org.jetbrains.annotations.Nullable;

public class ScreenUtil {
    public static final Rectangle getScreenRectangle(int aTargetX, int aTargetY) {
        GraphicsConfiguration targetGraphicsConfiguration = null;
        GraphicsEnvironment env = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice[] devices = env.getScreenDevices();
        for (int i = 0; i < devices.length; ++i) {
            GraphicsDevice device = devices[i];
            GraphicsConfiguration graphicsConfiguration = device.getDefaultConfiguration();
            Rectangle r = graphicsConfiguration.getBounds();
            if (r.x > aTargetX || aTargetX >= r.x + r.width || r.y > aTargetY || aTargetY >= r.y + r.height) continue;
            targetGraphicsConfiguration = graphicsConfiguration;
            break;
        }
        if (targetGraphicsConfiguration == null && devices.length > 0) {
            targetGraphicsConfiguration = env.getDefaultScreenDevice().getDefaultConfiguration();
        }
        if (targetGraphicsConfiguration == null) {
            throw new IllegalStateException("It's impossible to determine target graphics environment for point (" + aTargetX + "," + aTargetY + ")");
        }
        Insets insets = Toolkit.getDefaultToolkit().getScreenInsets(targetGraphicsConfiguration);
        Rectangle targetRectangle = targetGraphicsConfiguration.getBounds();
        targetRectangle.x += insets.left;
        targetRectangle.y += insets.top;
        targetRectangle.width -= insets.left + insets.right;
        targetRectangle.height -= insets.top + insets.bottom;
        return targetRectangle;
    }

    public static boolean isOutsideOnTheRightOFScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x;
        int screenY = aRectangle.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        return aRectangle.getMaxX() > screen.getMaxX();
    }

    public static void moveRectangleToFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x;
        int screenY = aRectangle.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        ScreenUtil.moveToFit(aRectangle, screen, null);
    }

    public static void moveToFit(Rectangle rectangle, Rectangle container, @Nullable Insets padding) {
        Insets insets = padding != null ? padding : new Insets(0, 0, 0, 0);
        Rectangle move = new Rectangle(rectangle.x - insets.left, rectangle.y - insets.top, rectangle.width + insets.left + insets.right, rectangle.height + insets.top + insets.bottom);
        if (move.getMaxX() > container.getMaxX()) {
            move.x = (int)container.getMaxX() - move.width;
        }
        if (move.getMinX() < container.getMinX()) {
            move.x = (int)container.getMinX();
        }
        if (move.getMaxY() > container.getMaxY()) {
            move.y = (int)container.getMaxY() - move.height;
        }
        if (move.getMinY() < container.getMinY()) {
            move.y = (int)container.getMinY();
        }
        rectangle.x = move.x + insets.left;
        rectangle.y = move.y + insets.right;
        rectangle.width = move.width - insets.left - insets.right;
        rectangle.height = move.height - insets.top - insets.bottom;
    }

    public static void fitToScreen(Rectangle r) {
        int yOverdraft;
        Rectangle screen = ScreenUtil.getScreenRectangle(r.x, r.y);
        int xOverdraft = r.x + r.width - screen.x - screen.width;
        if (xOverdraft > 0) {
            int shift = Math.min(xOverdraft, r.x - screen.x);
            r.x -= shift;
            if ((xOverdraft -= shift) > 0) {
                r.width -= xOverdraft;
            }
        }
        if ((yOverdraft = r.y + r.height - screen.y - screen.height) > 0) {
            int shift = Math.min(yOverdraft, r.y - screen.y);
            r.y -= shift;
            if ((yOverdraft -= shift) > 0) {
                r.height -= yOverdraft;
            }
        }
    }

    public static void cropRectangleToFitTheScreen(Rectangle aRectangle) {
        int screenX = aRectangle.x;
        int screenY = aRectangle.y;
        Rectangle screen = ScreenUtil.getScreenRectangle(screenX, screenY);
        if (aRectangle.getMaxX() > screen.getMaxX()) {
            aRectangle.width = (int)screen.getMaxX() - aRectangle.x;
        }
        if (aRectangle.getMinX() < screen.getMinX()) {
            aRectangle.x = (int)screen.getMinX();
        }
        if (aRectangle.getMaxY() > screen.getMaxY()) {
            aRectangle.height = (int)screen.getMaxY() - aRectangle.y;
        }
        if (aRectangle.getMinY() < screen.getMinY()) {
            aRectangle.y = (int)screen.getMinY();
        }
    }
}

