/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui;

import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;

public class DottedBorder
implements Border {
    private final Insets myInsets;
    private final Color myColor;

    public DottedBorder(Insets insets, Color color) {
        this.myInsets = insets;
        this.myColor = color;
    }

    public DottedBorder(Color color) {
        this.myInsets = new Insets(1, 1, 1, 1);
        this.myColor = color;
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        g.setColor(this.myColor);
        UIUtil.drawDottedRectangle((Graphics)g, (int)x, (int)y, (int)(x + width - 1), (int)(y + height - 1));
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.myInsets;
    }

    @Override
    public boolean isBorderOpaque() {
        return true;
    }
}

