/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.ide.hierarchy.HierarchyNodeDescriptor;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.JDOMUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.jdom.Document;
import org.jdom.Element;

public abstract class HierarchyViewTestBase
extends CodeInsightTestCase {
    private static final String NODE_ELEMENT_NAME = "node";
    private static final String ANY_NODES_ELEMENT_NAME = "any";
    private static final String TEXT_ATTR_NAME = "text";
    private static final String BASE_ATTR_NAME = "base";

    protected abstract String getBasePath();

    protected void doHierarchyTest(Computable<HierarchyTreeStructure> treeStructureComputable, String ... fileNames) throws Exception {
        String[] relFilePaths = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            relFilePaths[i] = "/" + this.getBasePath() + "/" + fileNames[i];
        }
        this.configureByFiles(null, relFilePaths);
        String verificationFilePath = this.getTestDataPath() + "/" + this.getBasePath() + "/" + this.getTestName(false) + "_verification.xml";
        HierarchyViewTestBase.checkHierarchyTreeStructure((HierarchyTreeStructure)treeStructureComputable.compute(), JDOMUtil.loadDocument((File)new File(verificationFilePath)));
    }

    private static void checkHierarchyTreeStructure(HierarchyTreeStructure treeStructure, Document document) {
        HierarchyNodeDescriptor rootNodeDescriptor = (HierarchyNodeDescriptor)treeStructure.getRootElement();
        rootNodeDescriptor.update();
        Element rootElement = document.getRootElement();
        if (rootElement == null || !NODE_ELEMENT_NAME.equals(rootElement.getName())) {
            throw new IllegalArgumentException("Incorrect root element in verification resource");
        }
        HierarchyViewTestBase.checkNodeDescriptorRecursively(treeStructure, rootNodeDescriptor, rootElement);
    }

    private static void checkNodeDescriptorRecursively(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element expectedElement) {
        HierarchyViewTestBase.checkBaseNode(treeStructure, descriptor, expectedElement);
        HierarchyViewTestBase.checkContent(descriptor, expectedElement);
        HierarchyViewTestBase.checkChildren(treeStructure, descriptor, expectedElement);
    }

    private static void checkBaseNode(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element expectedElement) {
        String baseAttrValue = expectedElement.getAttributeValue(BASE_ATTR_NAME);
        HierarchyNodeDescriptor baseDescriptor = treeStructure.getBaseDescriptor();
        boolean mustBeBase = "true".equalsIgnoreCase(baseAttrValue);
        HierarchyViewTestBase.assertTrue((String)"Incorrect base node", (boolean)(mustBeBase ? baseDescriptor == descriptor : baseDescriptor != descriptor));
    }

    private static void checkContent(HierarchyNodeDescriptor descriptor, Element expectedElement) {
        HierarchyViewTestBase.assertEquals((String)expectedElement.getAttributeValue(TEXT_ATTR_NAME), (String)descriptor.getHighlightedText().getText());
    }

    private static void checkChildren(HierarchyTreeStructure treeStructure, HierarchyNodeDescriptor descriptor, Element element) {
        if (element.getChild(ANY_NODES_ELEMENT_NAME) != null) {
            return;
        }
        Object[] children = treeStructure.getChildElements((Object)descriptor);
        ArrayList expectedChildren = new ArrayList(element.getChildren(NODE_ELEMENT_NAME));
        StringBuilder messageBuilder = new StringBuilder("Actual children of [" + descriptor.getHighlightedText().getText() + "]:\n");
        for (Object child : children) {
            HierarchyNodeDescriptor nodeDescriptor = (HierarchyNodeDescriptor)child;
            nodeDescriptor.update();
            messageBuilder.append("    [").append(nodeDescriptor.getHighlightedText().getText()).append("]\n");
        }
        HierarchyViewTestBase.assertEquals((String)messageBuilder.toString(), (int)expectedChildren.size(), (int)children.length);
        Arrays.sort(children, new Comparator<Object>(){

            @Override
            public int compare(Object first, Object second) {
                return ((HierarchyNodeDescriptor)first).getHighlightedText().getText().compareTo(((HierarchyNodeDescriptor)second).getHighlightedText().getText());
            }
        });
        Collections.sort(expectedChildren, new Comparator<Element>(){

            @Override
            public int compare(Element first, Element second) {
                return first.getAttributeValue(HierarchyViewTestBase.TEXT_ATTR_NAME).compareTo(second.getAttributeValue(HierarchyViewTestBase.TEXT_ATTR_NAME));
            }
        });
        Iterator iterator = expectedChildren.iterator();
        for (Object child : children) {
            HierarchyViewTestBase.checkNodeDescriptorRecursively(treeStructure, (HierarchyNodeDescriptor)child, (Element)iterator.next());
        }
    }
}

