/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.testFramework.IdeaTestUtil;
import com.intellij.testFramework.PsiTestUtil;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NonNls;

public abstract class MultiFileTestCase
extends CodeInsightTestCase {
    protected boolean myDoCompare = true;

    protected void doTest(PerformAction performAction) throws Exception {
        this.doTest(performAction, true);
    }

    protected void doTest(PerformAction performAction, boolean lowercaseFirstLetter) throws Exception {
        String testName = this.getTestName(lowercaseFirstLetter);
        String root = this.getTestDataPath() + this.getTestRoot() + testName;
        String rootBefore = root + "/before";
        VirtualFile rootDir = PsiTestUtil.createTestProjectStructure((Project)this.myProject, (Module)this.myModule, (String)rootBefore, (Collection)myFilesToDelete, (boolean)false);
        this.setupProject(rootDir);
        PsiDocumentManager.getInstance(this.myProject).commitAllDocuments();
        String rootAfter = root + "/after";
        VirtualFile rootDir2 = LocalFileSystem.getInstance().findFileByPath(rootAfter.replace(File.separatorChar, '/'));
        performAction.performAction(rootDir, rootDir2);
        this.myProject.getComponent(PostprocessReformattingAspect.class).doPostponedFormatting();
        FileDocumentManager.getInstance().saveAllDocuments();
        if (this.myDoCompare) {
            IdeaTestUtil.assertDirectoriesEqual(rootDir2, rootDir, IdeaTestUtil.CVS_FILE_FILTER);
        }
    }

    protected void setupProject(VirtualFile rootDir) {
        PsiTestUtil.addSourceContentToRoots((Module)this.myModule, (VirtualFile)rootDir);
    }

    @Override
    @NonNls
    protected abstract String getTestRoot();

    protected static interface PerformAction {
        public void performAction(VirtualFile var1, VirtualFile var2) throws Exception;
    }
}

