/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi;

import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeVisitor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiPrimitiveType
extends PsiType {
    private final String myName;
    @NonNls
    private static final Map<String, PsiPrimitiveType> ourQNameToUnboxed = new THashMap();
    @NonNls
    private static final Map<PsiPrimitiveType, String> ourUnboxedToQName = new THashMap();

    public PsiPrimitiveType(@NonNls @NotNull String name, PsiAnnotation[] annotations) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiPrimitiveType.<init> must not be null");
        }
        super(annotations);
        this.myName = name;
    }

    PsiPrimitiveType(@NonNls @NotNull String name, @NonNls String boxedName) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/psi/PsiPrimitiveType.<init> must not be null");
        }
        this(name, PsiAnnotation.EMPTY_ARRAY);
        if (boxedName != null) {
            ourQNameToUnboxed.put(boxedName, this);
            ourUnboxedToQName.put(this, boxedName);
        }
    }

    @Override
    public String getPresentableText() {
        return this.myName;
    }

    @Override
    public String getCanonicalText() {
        return this.myName;
    }

    @Override
    public String getInternalCanonicalText() {
        return this.getAnnotationsTextPrefix() + this.getCanonicalText();
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public boolean equalsToText(String text) {
        return this.myName.equals(text);
    }

    @Override
    public <A> A accept(PsiTypeVisitor<A> visitor) {
        return visitor.visitPrimitiveType(this);
    }

    @Override
    public GlobalSearchScope getResolveScope() {
        return null;
    }

    @Override
    @NotNull
    public PsiType[] getSuperTypes() {
        PsiType[] psiTypeArray = new PsiType[]{};
        if (psiTypeArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/psi/PsiPrimitiveType.getSuperTypes must not return null");
        }
        return psiTypeArray;
    }

    @Nullable
    public static PsiPrimitiveType getUnboxedType(PsiType type) {
        if (!(type instanceof PsiClassType)) {
            return null;
        }
        if (!((PsiClassType)type).getLanguageLevel().hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        PsiClass psiClass = ((PsiClassType)type).resolve();
        if (psiClass == null) {
            return null;
        }
        return ourQNameToUnboxed.get(psiClass.getQualifiedName());
    }

    public String getBoxedTypeName() {
        return ourUnboxedToQName.get(this);
    }

    @Nullable
    public PsiClassType getBoxedType(PsiElement context) {
        LanguageLevel languageLevel = PsiUtil.getLanguageLevel(context);
        if (!languageLevel.hasEnumKeywordAndAutoboxing()) {
            return null;
        }
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiManager manager = context.getManager();
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, context.getResolveScope());
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass, PsiSubstitutor.EMPTY, languageLevel);
    }

    @Nullable
    public PsiClassType getBoxedType(PsiManager manager, GlobalSearchScope resolveScope) {
        String boxedQName = this.getBoxedTypeName();
        if (boxedQName == null) {
            return null;
        }
        PsiClass aClass = JavaPsiFacade.getInstance(manager.getProject()).findClass(boxedQName, resolveScope);
        if (aClass == null) {
            return null;
        }
        return JavaPsiFacade.getInstance(manager.getProject()).getElementFactory().createType(aClass);
    }

    public static Collection<String> getAllBoxedTypeNames() {
        return Collections.unmodifiableCollection(ourQNameToUnboxed.keySet());
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof PsiPrimitiveType && this.myName.equals(((PsiPrimitiveType)obj).myName);
    }
}

