/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profile;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.profile.Profile;
import com.intellij.profile.ProfileManager;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ProfileEx
implements Profile {
    public String myName;
    private static final Logger LOG = Logger.getInstance((String)"com.intellij.profile.ProfileEx");
    public boolean myLocal;
    protected ProfileManager myProfileMananger;

    public ProfileEx(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/ProfileEx.<init> must not be null");
        }
        this.myLocal = true;
        this.myName = name;
    }

    public ProfileEx(String name, Element element) {
        this(name);
    }

    @Override
    public String getName() {
        return this.myName;
    }

    @Override
    public void copyFrom(@NotNull Profile profile) {
        if (profile == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/ProfileEx.copyFrom must not be null");
        }
        try {
            Element config = new Element("config");
            profile.writeExternal(config);
            this.readExternal(config);
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public void setLocal(boolean isLocal) {
        this.myLocal = isLocal;
    }

    @Override
    public boolean isLocal() {
        return this.myLocal;
    }

    @Override
    public void setName(String name) {
        this.myName = name;
    }

    @Override
    public void setProfileManager(@NotNull ProfileManager profileManager) {
        if (profileManager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/profile/ProfileEx.setProfileManager must not be null");
        }
        this.myProfileMananger = profileManager;
    }

    @Override
    @NotNull
    public ProfileManager getProfileManager() {
        ProfileManager profileManager = this.myProfileMananger;
        if (profileManager == null) {
            throw new IllegalStateException("@NotNull method com/intellij/profile/ProfileEx.getProfileManager must not return null");
        }
        return profileManager;
    }

    public void readExternal(Element element) throws InvalidDataException {
        DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ProfileEx)) {
            return false;
        }
        ProfileEx profileEx = (ProfileEx)o;
        return this.myName.equals(profileEx.myName);
    }

    public int hashCode() {
        return this.myName.hashCode();
    }

    public int compareTo(Object o) {
        if (o instanceof Profile) {
            return this.getName().compareToIgnoreCase(((Profile)o).getName());
        }
        return 0;
    }
}

