/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.update.FileGroup;
import java.util.ArrayList;
import java.util.List;
import org.jdom.Element;

public class UpdatedFiles
implements JDOMExternalizable {
    private final List<FileGroup> myGroups = new ArrayList<FileGroup>();

    private UpdatedFiles() {
    }

    public FileGroup registerGroup(FileGroup fileGroup) {
        FileGroup existing = this.getGroupById(fileGroup.getId());
        if (existing != null) {
            return existing;
        }
        this.myGroups.add(fileGroup);
        return fileGroup;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        FileGroup.writeGroupsToElement(this.myGroups, element);
    }

    public void readExternal(Element element) throws InvalidDataException {
        FileGroup.readGroupsFromElement(this.myGroups, element);
    }

    public boolean isEmpty() {
        for (FileGroup fileGroup : this.myGroups) {
            if (fileGroup.isEmpty()) continue;
            return false;
        }
        return true;
    }

    public FileGroup getGroupById(String id) {
        if (id == null) {
            return null;
        }
        return UpdatedFiles.findByIdIn(this.myGroups, id);
    }

    private static FileGroup findByIdIn(List<FileGroup> groups, String id) {
        for (FileGroup fileGroup : groups) {
            if (id.equals(fileGroup.getId())) {
                return fileGroup;
            }
            FileGroup foundInChildren = UpdatedFiles.findByIdIn(fileGroup.getChildren(), id);
            if (foundInChildren == null) continue;
            return foundInChildren;
        }
        return null;
    }

    public List<FileGroup> getTopLevelGroups() {
        return this.myGroups;
    }

    public static UpdatedFiles create() {
        UpdatedFiles result = new UpdatedFiles();
        FileGroup updatedFromServer = result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.updated.from.server", new Object[0]), VcsBundle.message("status.group.name.changed.on.server", new Object[0]), false, "CHANGED_ON_SERVER", false));
        updatedFromServer.addChild(new FileGroup(VcsBundle.message("update.group.name.updated", new Object[0]), VcsBundle.message("status.group.name.changed", new Object[0]), false, "UPDATED", false));
        updatedFromServer.addChild(new FileGroup(VcsBundle.message("update.group.name.created", new Object[0]), VcsBundle.message("status.group.name.created", new Object[0]), false, "CREATED", false));
        updatedFromServer.addChild(new FileGroup(VcsBundle.message("update.group.name.deleted", new Object[0]), VcsBundle.message("status.group.name.deleted", new Object[0]), false, "REMOVED_FROM_REPOSITORY", true));
        updatedFromServer.addChild(new FileGroup(VcsBundle.message("update.group.name.restored", new Object[0]), VcsBundle.message("status.group.name.will.be.restored", new Object[0]), false, "RESTORED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.modified", new Object[0]), VcsBundle.message("status.group.name.modified", new Object[0]), false, "MODIFIED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.skipped", new Object[0]), VcsBundle.message("status.group.name.skipped", new Object[0]), false, "SKIPPED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.merged.with.conflicts", new Object[0]), VcsBundle.message("status.group.name.will.be.merged.with.conflicts", new Object[0]), false, "MERGED_WITH_CONFLICTS", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.merged.with.tree.conflicts", new Object[0]), VcsBundle.message("update.group.name.merged.with.tree.conflicts", new Object[0]), false, "MERGED_WITH_TREE_CONFLICT", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.merged", new Object[0]), VcsBundle.message("status.group.name.will.be.merged", new Object[0]), false, "MERGED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.not.in.repository", new Object[0]), VcsBundle.message("status.group.name.not.in.repository", new Object[0]), true, "UNKNOWN", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.locally.added", new Object[0]), VcsBundle.message("status.group.name.locally.added", new Object[0]), false, "LOCALLY_ADDED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.locally.removed", new Object[0]), VcsBundle.message("status.group.name.locally.removed", new Object[0]), false, "LOCALLY_REMOVED", false));
        result.registerGroup(new FileGroup(VcsBundle.message("update.group.name.switched", new Object[0]), VcsBundle.message("status.group.name.switched", new Object[0]), false, "SWITCHED", false));
        return result;
    }

    public void setRevisions(String path, AbstractVcs vcs, VcsRevisionNumber revision) {
        for (FileGroup group : this.myGroups) {
            group.setRevisions(path, vcs, revision);
        }
    }
}

