/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.ui;

import com.intellij.CommonBundle;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.FileStatusManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ui.FilePathSplittingPolicy;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;

public class ReplaceFileConfirmationDialog {
    private final FileStatusManager myFileStatusManager;
    ProgressIndicator myProgressIndicator = ProgressManager.getInstance().getProgressIndicator();
    private final String myActionName;

    public ReplaceFileConfirmationDialog(Project project, String actionName) {
        this.myFileStatusManager = FileStatusManager.getInstance(project);
        this.myActionName = actionName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean confirmFor(VirtualFile[] files) {
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            return true;
        }
        if (this.myProgressIndicator != null) {
            this.myProgressIndicator.pushState();
        }
        try {
            Collection<VirtualFile> modifiedFiles = this.collectModifiedFiles(files);
            if (modifiedFiles.isEmpty()) {
                boolean bl = true;
                return bl;
            }
            boolean bl = this.requestConfirmation(modifiedFiles);
            return bl;
        }
        finally {
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.popState();
            }
        }
    }

    public boolean requestConfirmation(Collection modifiedFiles) {
        if (modifiedFiles.isEmpty()) {
            return true;
        }
        return Messages.showDialog(this.createMessage(modifiedFiles), this.myActionName, new String[]{this.createOwerriteButtonName(modifiedFiles), this.getCancelButtonText()}, 0, Messages.getWarningIcon()) == 0;
    }

    protected String getCancelButtonText() {
        return CommonBundle.getCancelButtonText();
    }

    private String createOwerriteButtonName(Collection modifiedFiles) {
        return modifiedFiles.size() > 1 ? this.getOkButtonTextForFiles() : this.getOkButtonTextForOneFile();
    }

    protected String getOkButtonTextForOneFile() {
        return VcsBundle.message("button.text.overwrite.modified.file", new Object[0]);
    }

    protected String getOkButtonTextForFiles() {
        return VcsBundle.message("button.text.overwrite.modified.files", new Object[0]);
    }

    protected String createMessage(Collection modifiedFiles) {
        if (modifiedFiles.size() == 1) {
            VirtualFile virtualFile = (VirtualFile)modifiedFiles.iterator().next();
            return VcsBundle.message("message.text.file.locally.modified", FilePathSplittingPolicy.SPLIT_BY_LETTER.getPresentableName(new File(virtualFile.getPath()), 40));
        }
        return VcsBundle.message("message.text.several.files.locally.modified", new Object[0]);
    }

    public Collection<VirtualFile> collectModifiedFiles(VirtualFile[] files) {
        ArrayList<VirtualFile> result = new ArrayList<VirtualFile>();
        if (files == null) {
            return result;
        }
        for (int i = 0; i < files.length; ++i) {
            FileStatus status;
            VirtualFile file = files[i];
            if (this.myProgressIndicator != null) {
                this.myProgressIndicator.setText(VcsBundle.message("progress.text.searching.for.modified.files", new Object[0]));
                this.myProgressIndicator.setText2(file.getPresentableUrl());
            }
            if ((status = this.myFileStatusManager.getStatus(file)) != FileStatus.NOT_CHANGED) {
                result.add(file);
                if (result.size() > 1) {
                    return result;
                }
            }
            result.addAll(this.collectModifiedFiles(file.getChildren()));
        }
        return result;
    }
}

