/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui.popup.util;

import com.intellij.openapi.ui.popup.JBPopup;
import java.awt.Component;
import java.awt.Window;
import javax.swing.JRootPane;
import javax.swing.JWindow;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class PopupUtil {
    private PopupUtil() {
    }

    @Nullable
    public static Component getOwner(@Nullable Component c) {
        if (c == null) {
            return null;
        }
        Window wnd = SwingUtilities.getWindowAncestor(c);
        if (wnd instanceof JWindow) {
            JRootPane root = ((JWindow)wnd).getRootPane();
            JBPopup popup = (JBPopup)root.getClientProperty("JBPopup");
            if (popup == null) {
                return c;
            }
            Component owner = popup.getOwner();
            if (owner == null) {
                return c;
            }
            return PopupUtil.getOwner(owner);
        }
        return c;
    }
}

