/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.ui;

import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MasterDetailsComponent;
import com.intellij.util.xmlb.annotations.MapAnnotation;
import com.intellij.util.xmlb.annotations.Tag;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

@com.intellij.openapi.components.State(name="masterDetails", storages={@Storage(id="other", file="$WORKSPACE_FILE$")})
public class MasterDetailsStateService
implements PersistentStateComponent<State> {
    private Map<String, MasterDetailsComponent> myComponents = new HashMap<String, MasterDetailsComponent>();
    private State myStates = new State();

    public static MasterDetailsStateService getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/openapi/ui/MasterDetailsStateService.getInstance must not be null");
        }
        return ServiceManager.getService(project, MasterDetailsStateService.class);
    }

    public void register(@NonNls String key, MasterDetailsComponent masterDetailsComponent) {
        this.myComponents.put(key, masterDetailsComponent);
        MasterDetailsComponent.UIState loadedState = this.myStates.getStates().get(key);
        if (loadedState != null) {
            masterDetailsComponent.loadState(loadedState);
        }
    }

    @Override
    public State getState() {
        for (Map.Entry<String, MasterDetailsComponent> entry : this.myComponents.entrySet()) {
            this.myStates.getStates().put(entry.getKey(), entry.getValue().getState());
        }
        return this.myStates;
    }

    @Override
    public void loadState(State state) {
        this.myStates.setStates(state.getStates());
        for (Map.Entry<String, MasterDetailsComponent.UIState> entry : this.myStates.getStates().entrySet()) {
            MasterDetailsComponent component = this.myComponents.get(entry.getKey());
            if (component == null) continue;
            component.loadState(entry.getValue());
        }
    }

    public static class State {
        private Map<String, MasterDetailsComponent.UIState> myStates = new HashMap<String, MasterDetailsComponent.UIState>();

        @Tag(value="states")
        @MapAnnotation(surroundWithTag=false, entryTagName="state", surroundKeyWithTag=false, surroundValueWithTag=false)
        public Map<String, MasterDetailsComponent.UIState> getStates() {
            return this.myStates;
        }

        public void setStates(Map<String, MasterDetailsComponent.UIState> states) {
            this.myStates = states;
        }
    }
}

