/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.roots.ui;

import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import org.jetbrains.annotations.NotNull;

public class LightFilePointer {
    private final String myUrl;
    private VirtualFile myFile;

    public LightFilePointer(String url) {
        this.myUrl = url;
    }

    public VirtualFile getFile() {
        this.refreshFile();
        return this.myFile;
    }

    @NotNull
    public String getUrl() {
        String string = this.myUrl;
        if (string == null) {
            throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/LightFilePointer.getUrl must not return null");
        }
        return string;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getFileName() {
        String string;
        if (this.myFile != null) {
            string = this.myFile.getName();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/LightFilePointer.getFileName must not return null");
            return string;
        }
        int index = this.myUrl.lastIndexOf(47);
        string = index >= 0 ? this.myUrl.substring(index + 1) : this.myUrl;
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/LightFilePointer.getFileName must not return null");
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public String getPresentableUrl() {
        String string;
        VirtualFile file = this.getFile();
        if (file != null) {
            string = file.getPresentableUrl();
            if (string == null) throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/LightFilePointer.getPresentableUrl must not return null");
            return string;
        }
        string = LightFilePointer.toPresentableUrl(this.myUrl);
        if (string != null) return string;
        throw new IllegalStateException("@NotNull method com/intellij/openapi/roots/ui/LightFilePointer.getPresentableUrl must not return null");
    }

    public static String toPresentableUrl(String url) {
        String path = VirtualFileManager.extractPath(url);
        if (path.endsWith("!/")) {
            path = path.substring(0, path.length() - "!/".length());
        }
        return path.replace('/', File.separatorChar);
    }

    public boolean isValid() {
        return this.getFile() != null;
    }

    private void refreshFile() {
        if (this.myFile != null && this.myFile.isValid()) {
            return;
        }
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(this.myUrl);
        this.myFile = virtualFile != null && virtualFile.isValid() ? virtualFile : null;
    }
}

