/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lexer;

import com.intellij.lang.Language;
import com.intellij.lexer.LexerBase;
import com.intellij.lexer.LexerPosition;
import com.intellij.lexer.LexerPositionImpl;
import com.intellij.psi.tree.IElementType;

public class EmptyLexer
extends LexerBase {
    private CharSequence myBuffer;
    private int myStartOffset;
    private int myEndOffset;
    private static final IElementType EMPTY_TOKEN_TYPE = new IElementType("empty token", Language.ANY);

    @Override
    public void start(CharSequence buffer, int startOffset, int endOffset, int initialState) {
        this.myBuffer = buffer;
        this.myStartOffset = startOffset;
        this.myEndOffset = endOffset;
    }

    @Override
    public CharSequence getBufferSequence() {
        return this.myBuffer;
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public IElementType getTokenType() {
        return this.myStartOffset < this.myEndOffset ? EMPTY_TOKEN_TYPE : null;
    }

    @Override
    public int getTokenStart() {
        return this.myStartOffset;
    }

    @Override
    public int getTokenEnd() {
        return this.myEndOffset;
    }

    @Override
    public void advance() {
        this.myStartOffset = this.myEndOffset;
    }

    @Override
    public LexerPosition getCurrentPosition() {
        return new LexerPositionImpl(0, this.getState());
    }

    @Override
    public void restore(LexerPosition position) {
    }

    @Override
    public int getBufferEnd() {
        return this.myEndOffset;
    }
}

