/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.util.frameworkSupport;

import com.intellij.ide.util.frameworkSupport.FrameworkSupportConfigurableListener;
import com.intellij.ide.util.frameworkSupport.FrameworkVersion;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.util.EventDispatcher;
import java.util.EventListener;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FrameworkSupportConfigurable {
    private final EventDispatcher<FrameworkSupportConfigurableListener> myDispatcher = EventDispatcher.create(FrameworkSupportConfigurableListener.class);

    @Nullable
    public abstract JComponent getComponent();

    public abstract void addSupport(@NotNull Module var1, @NotNull ModifiableRootModel var2, @Nullable Library var3);

    public FrameworkVersion getSelectedVersion() {
        return null;
    }

    public void onFrameworkSelectionChanged(boolean selected) {
    }

    public void addListener(@NotNull FrameworkSupportConfigurableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurable.addListener must not be null");
        }
        this.myDispatcher.addListener((EventListener)listener);
    }

    public void removeListener(@NotNull FrameworkSupportConfigurableListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/ide/util/frameworkSupport/FrameworkSupportConfigurable.removeListener must not be null");
        }
        this.myDispatcher.removeListener((EventListener)listener);
    }

    protected void fireFrameworkVersionChanged() {
        ((FrameworkSupportConfigurableListener)this.myDispatcher.getMulticaster()).frameworkVersionChanged();
    }
}

