/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.filters;

import com.intellij.execution.ConsoleFolding;
import com.intellij.execution.filters.ExceptionFilter;
import com.intellij.execution.filters.StackFrameFilter;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.Trinity;
import java.util.List;

public class AuxiliaryCallsFolding
extends ConsoleFolding {
    public boolean shouldFoldLine(String line) {
        Trinity<String, String, TextRange> pair = ExceptionFilter.parseExceptionLine(line);
        return pair != null && AuxiliaryCallsFolding.shouldFold((String)pair.first, (String)pair.second);
    }

    private static boolean shouldFold(String className, String methodName) {
        for (StackFrameFilter provider : (StackFrameFilter[])StackFrameFilter.EP_NAME.getExtensions()) {
            if (!provider.isAuxiliaryFrame(className, methodName)) continue;
            return true;
        }
        return false;
    }

    public String getPlaceholderText(List<String> lines) {
        return " <" + lines.size() + " internal calls>";
    }
}

