/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.configurations;

import com.intellij.execution.configurations.ConfigurationFactory;
import com.intellij.execution.configurations.RunConfigurationModule;
import com.intellij.execution.configurations.RuntimeConfiguration;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import java.util.Arrays;
import java.util.Collection;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ModuleBasedConfiguration<ConfigurationModule extends RunConfigurationModule>
extends RuntimeConfiguration {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.execution.configurations.ModuleBasedConfiguration");
    private final ConfigurationModule myModule;
    @NonNls
    protected static final String TO_CLONE_ELEMENT_NAME = "toClone";

    public ModuleBasedConfiguration(String name, ConfigurationModule configurationModule, ConfigurationFactory factory) {
        super(name, ((RunConfigurationModule)configurationModule).getProject(), factory);
        this.myModule = configurationModule;
    }

    public abstract Collection<Module> getValidModules();

    public ConfigurationModule getConfigurationModule() {
        return this.myModule;
    }

    public void setModule(Module module) {
        ((RunConfigurationModule)this.myModule).setModule(module);
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        super.readExternal(element);
    }

    @Override
    public void writeExternal(Element element) throws WriteExternalException {
        super.writeExternal(element);
    }

    protected void readModule(Element element) throws InvalidDataException {
        ((RunConfigurationModule)this.myModule).readExternal(element);
    }

    protected void writeModule(Element element) throws WriteExternalException {
        ((RunConfigurationModule)this.myModule).writeExternal(element);
    }

    public Collection<Module> getAllModules() {
        return Arrays.asList(ModuleManager.getInstance(this.getProject()).getModules());
    }

    protected abstract ModuleBasedConfiguration createInstance();

    @Override
    public ModuleBasedConfiguration clone() {
        Element element = new Element(TO_CLONE_ELEMENT_NAME);
        try {
            this.writeExternal(element);
            ModuleBasedConfiguration configuration = this.createInstance();
            configuration.readExternal(element);
            return configuration;
        }
        catch (InvalidDataException e) {
            LOG.error((Throwable)e);
            return null;
        }
        catch (WriteExternalException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }

    @Override
    @NotNull
    public Module[] getModules() {
        Module[] moduleArray = ApplicationManager.getApplication().runReadAction(new Computable<Module[]>(){

            public Module[] compute() {
                Module[] moduleArray;
                Module module = ((RunConfigurationModule)ModuleBasedConfiguration.this.getConfigurationModule()).getModule();
                if (module == null) {
                    moduleArray = Module.EMPTY_ARRAY;
                } else {
                    Module[] moduleArray2 = new Module[1];
                    moduleArray = moduleArray2;
                    moduleArray2[0] = module;
                }
                return moduleArray;
            }
        });
        if (moduleArray == null) {
            throw new IllegalStateException("@NotNull method com/intellij/execution/configurations/ModuleBasedConfiguration.getModules must not return null");
        }
        return moduleArray;
    }

    public void restoreOriginalModule(Module originalModule) {
        if (originalModule == null) {
            return;
        }
        Module[] classModules = this.getModules();
        Collection<Module> modules = ModuleUtil.collectModulesDependsOn(Arrays.asList(classModules));
        if (modules.contains(originalModule)) {
            this.setModule(originalModule);
        }
    }
}

