/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.CompositeGenerator;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.ModuleChunk;
import com.intellij.compiler.ant.PropertyFileGenerator;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class ChunkBuildExtension {
    public static final ExtensionPointName<ChunkBuildExtension> EP_NAME = ExtensionPointName.create((String)"com.intellij.antBuildGen");

    @NotNull
    @NonNls
    public abstract String[] getTargets(ModuleChunk var1);

    public abstract void process(Project var1, ModuleChunk var2, GenerationOptions var3, CompositeGenerator var4);

    public void generateProperties(PropertyFileGenerator generator, Project project, GenerationOptions options) {
    }

    public static String[] getAllTargets(ModuleChunk chunk) {
        ChunkBuildExtension[] extensions;
        ArrayList<String> allTargets = new ArrayList<String>();
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            allTargets.addAll(Arrays.asList(extension.getTargets(chunk)));
        }
        if (allTargets.isEmpty()) {
            allTargets.add(BuildProperties.getCompileTargetName(chunk.getName()));
        }
        return ArrayUtil.toStringArray(allTargets);
    }

    public static void process(CompositeGenerator generator, ModuleChunk chunk, GenerationOptions genOptions) {
        ChunkBuildExtension[] extensions;
        Project project = chunk.getProject();
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            extension.process(project, chunk, genOptions, generator);
        }
    }

    public static void generateAllProperties(PropertyFileGenerator propertyFileGenerator, Project project, GenerationOptions genOptions) {
        ChunkBuildExtension[] extensions;
        for (ChunkBuildExtension extension : extensions = (ChunkBuildExtension[])Extensions.getRootArea().getExtensionPoint(EP_NAME).getExtensions()) {
            extension.generateProperties(propertyFileGenerator, project, genOptions);
        }
    }
}

