/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.LocalQuickFixProvider;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.ExternallyDefinedPsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemsHolder {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ProblemsHolder");
    private final InspectionManager myManager;
    private final PsiFile myFile;
    private final boolean myOnTheFly;
    private List<ProblemDescriptor> myProblems;

    public ProblemsHolder(@NotNull InspectionManager manager, @NotNull PsiFile file, boolean onTheFly) {
        if (manager == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.<init> must not be null");
        }
        if (file == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.<init> must not be null");
        }
        this.myProblems = null;
        this.myManager = manager;
        this.myFile = file;
        this.myOnTheFly = onTheFly;
    }

    public void registerProblem(@NotNull PsiElement psiElement, @Nls String descriptionTemplate, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        this.registerProblem(psiElement, descriptionTemplate, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, fixes);
    }

    public void registerProblem(@NotNull PsiElement psiElement, String descriptionTemplate, ProblemHighlightType highlightType, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        this.registerProblem(this.myManager.createProblemDescriptor(psiElement, descriptionTemplate, this.myOnTheFly, fixes, highlightType));
    }

    public void registerProblem(@NotNull ProblemDescriptor problemDescriptor) {
        if (problemDescriptor == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        PsiElement element = problemDescriptor.getPsiElement();
        if (element != null && !this.isInPsiFile(element)) {
            PsiElement newTarget;
            ExternallyDefinedPsiElement external = PsiTreeUtil.getParentOfType(element, ExternallyDefinedPsiElement.class, false);
            if (external != null && (newTarget = external.getProblemTarget()) != null) {
                this.redirectProblem(problemDescriptor, newTarget);
                return;
            }
            PsiFile containingFile = element.getContainingFile();
            PsiElement context = containingFile.getContext();
            PsiElement myContext = this.myFile.getContext();
            LOG.error("Reported element " + element + " is not from the file '" + this.myFile + "' the inspection was invoked for. Message: '" + problemDescriptor.getDescriptionTemplate() + "'.\n" + "Element' containing file: " + containingFile + "; context: " + (context == null ? null : context.getContainingFile()) + "\n" + "Inspection invoked for file: " + this.myFile + "; context: " + (myContext == null ? null : myContext.getContainingFile()) + "\n");
        }
        if (this.myProblems == null) {
            this.myProblems = new ArrayList<ProblemDescriptor>(1);
        }
        this.myProblems.add(problemDescriptor);
    }

    private boolean isInPsiFile(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.isInPsiFile must not be null");
        }
        PsiFile file = element.getContainingFile();
        return ArrayUtil.indexOf((Object[])this.myFile.getPsiRoots(), (Object)file) != -1;
    }

    private void redirectProblem(@NotNull ProblemDescriptor problem, @NotNull PsiElement target) {
        if (problem == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.redirectProblem must not be null");
        }
        if (target == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.redirectProblem must not be null");
        }
        PsiElement original = problem.getPsiElement();
        VirtualFile vFile = original.getContainingFile().getVirtualFile();
        assert (vFile != null);
        String path = FileUtil.toSystemIndependentName((String)vFile.getPath());
        String description = problem.getDescriptionTemplate();
        if (description.startsWith("<html>")) {
            description = description.replace("<html>", "").replace("</html>", "");
        }
        if (description.startsWith("<body>")) {
            description = description.replace("<body>", "").replace("</body>", "");
        }
        String template = InspectionsBundle.message("inspection.redirect.template", description, path, original.getTextRange().getStartOffset(), vFile.getName());
        InspectionManager manager = InspectionManager.getInstance(original.getProject());
        ProblemDescriptor newProblem = manager.createProblemDescriptor(target, template, (LocalQuickFix)null, problem.getHighlightType(), this.isOnTheFly());
        this.registerProblem(newProblem);
    }

    public void registerProblem(@NotNull PsiReference reference, String descriptionTemplate, ProblemHighlightType highlightType) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        LocalQuickFix[] fixes = null;
        if (reference instanceof LocalQuickFixProvider) {
            fixes = ((LocalQuickFixProvider)((Object)reference)).getQuickFixes();
        }
        this.registerProblem(this.myManager.createProblemDescriptor(reference.getElement(), reference.getRangeInElement(), descriptionTemplate, highlightType, this.myOnTheFly, fixes));
    }

    public void registerProblem(@NotNull PsiReference reference) {
        if (reference == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        assert (reference instanceof EmptyResolveMessageProvider);
        this.registerProblem(reference, ((EmptyResolveMessageProvider)((Object)reference)).getUnresolvedMessagePattern(), ProblemHighlightType.LIKE_UNKNOWN_SYMBOL);
    }

    public void registerProblem(@NotNull PsiElement psiElement, @NotNull String message, ProblemHighlightType highlightType, TextRange rangeInElement, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(psiElement, rangeInElement, message, highlightType, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    public void registerProblem(@NotNull PsiElement psiElement, TextRange rangeInElement, @NotNull String message, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        if (message == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInspection/ProblemsHolder.registerProblem must not be null");
        }
        ProblemDescriptor descriptor = this.myManager.createProblemDescriptor(psiElement, rangeInElement, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, this.myOnTheFly, fixes);
        this.registerProblem(descriptor);
    }

    @Nullable
    public List<ProblemDescriptor> getResults() {
        List<ProblemDescriptor> problems = this.myProblems;
        this.myProblems = null;
        return problems;
    }

    @Nullable
    public ProblemDescriptor[] getResultsArray() {
        List<ProblemDescriptor> problems = this.myProblems;
        this.myProblems = null;
        return problems == null ? null : problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    public final InspectionManager getManager() {
        return this.myManager;
    }

    public boolean hasResults() {
        return this.myProblems != null && !this.myProblems.isEmpty();
    }

    public boolean isOnTheFly() {
        return this.myOnTheFly;
    }

    public final Project getProject() {
        return this.myManager.getProject();
    }
}

