/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.navigation;

import com.intellij.codeInsight.daemon.GutterIconNavigationHandler;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.codeInsight.navigation.NavigationUtil;
import com.intellij.ide.util.PsiElementListCellRenderer;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.ui.popup.JBPopup;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.util.Function;
import com.intellij.util.NullableFunction;
import com.intellij.util.PsiNavigateUtil;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.JLabel;
import org.jetbrains.annotations.Nullable;

public abstract class NavigationGutterIconRenderer
extends GutterIconRenderer
implements GutterIconNavigationHandler<PsiElement> {
    private final String myPopupTitle;
    private final String myEmptyText;
    private final PsiElementListCellRenderer myCellRenderer;
    private final NotNullLazyValue<List<SmartPsiElementPointer>> myPointers;

    protected NavigationGutterIconRenderer(String popupTitle, String emptyText, PsiElementListCellRenderer cellRenderer, NotNullLazyValue<List<SmartPsiElementPointer>> pointers) {
        this.myPopupTitle = popupTitle;
        this.myEmptyText = emptyText;
        this.myCellRenderer = cellRenderer;
        this.myPointers = pointers;
    }

    @Override
    public boolean isNavigateAction() {
        return true;
    }

    public List<PsiElement> getTargetElements() {
        return ContainerUtil.mapNotNull((Iterable)((Iterable)this.myPointers.getValue()), (Function)new NullableFunction<SmartPsiElementPointer, PsiElement>(){

            public PsiElement fun(SmartPsiElementPointer smartPsiElementPointer) {
                return smartPsiElementPointer.getElement();
            }
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NavigationGutterIconRenderer renderer = (NavigationGutterIconRenderer)o;
        if (this.myCellRenderer != null ? !this.myCellRenderer.equals(renderer.myCellRenderer) : renderer.myCellRenderer != null) {
            return false;
        }
        if (this.myEmptyText != null ? !this.myEmptyText.equals(renderer.myEmptyText) : renderer.myEmptyText != null) {
            return false;
        }
        if (!this.myPointers.equals(renderer.myPointers)) {
            return false;
        }
        return !(this.myPopupTitle != null ? !this.myPopupTitle.equals(renderer.myPopupTitle) : renderer.myPopupTitle != null);
    }

    public int hashCode() {
        int result = this.myPopupTitle != null ? this.myPopupTitle.hashCode() : 0;
        result = 31 * result + (this.myEmptyText != null ? this.myEmptyText.hashCode() : 0);
        result = 31 * result + (this.myCellRenderer != null ? this.myCellRenderer.hashCode() : 0);
        result = 31 * result + this.myPointers.hashCode();
        return result;
    }

    public PsiElementListCellRenderer getCellRenderer() {
        return this.myCellRenderer;
    }

    @Override
    @Nullable
    public AnAction getClickAction() {
        return new AnAction(){

            @Override
            public void actionPerformed(AnActionEvent e) {
                NavigationGutterIconRenderer.this.navigate(e == null ? null : (MouseEvent)e.getInputEvent(), null);
            }
        };
    }

    @Override
    public void navigate(MouseEvent event, PsiElement elt) {
        List<PsiElement> list = this.getTargetElements();
        if (list.isEmpty()) {
            if (this.myEmptyText != null) {
                JLabel renderer = HintUtil.createErrorLabel((String)this.myEmptyText);
                JBPopup popup = JBPopupFactory.getInstance().createComponentPopupBuilder(renderer, renderer).createPopup();
                if (event != null) {
                    popup.show(new RelativePoint(event));
                }
            }
            return;
        }
        if (list.size() == 1) {
            PsiNavigateUtil.navigate(list.iterator().next());
        } else {
            JBPopup popup = NavigationUtil.getPsiElementPopup((PsiElement[])list.toArray(new PsiElement[list.size()]), (PsiElementListCellRenderer)this.myCellRenderer, (String)this.myPopupTitle);
            if (event != null) {
                popup.show(new RelativePoint(event));
            }
        }
    }
}

