/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.completion;

import com.intellij.codeInsight.completion.CompletionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompletionParameters {
    private final PsiElement myPosition;
    private final PsiFile myOriginalFile;
    private final CompletionType myCompletionType;
    private final int myOffset;
    private final int myInvocationCount;

    public CompletionParameters(@NotNull PsiElement position, @NotNull PsiFile originalFile, CompletionType completionType, int offset, int invocationCount) {
        if (position == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionParameters.<init> must not be null");
        }
        if (originalFile == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/completion/CompletionParameters.<init> must not be null");
        }
        assert (offset >= position.getTextRange().getStartOffset());
        this.myPosition = position;
        this.myOriginalFile = originalFile;
        this.myCompletionType = completionType;
        this.myOffset = offset;
        this.myInvocationCount = invocationCount;
    }

    @NotNull
    public PsiElement getPosition() {
        PsiElement psiElement = this.myPosition;
        if (psiElement == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionParameters.getPosition must not return null");
        }
        return psiElement;
    }

    @Nullable
    public PsiElement getOriginalPosition() {
        return this.myOriginalFile.findElementAt(this.myPosition.getTextRange().getStartOffset());
    }

    @NotNull
    public PsiFile getOriginalFile() {
        PsiFile psiFile = this.myOriginalFile;
        if (psiFile == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionParameters.getOriginalFile must not return null");
        }
        return psiFile;
    }

    @NotNull
    public CompletionType getCompletionType() {
        CompletionType completionType = this.myCompletionType;
        if (completionType == null) {
            throw new IllegalStateException("@NotNull method com/intellij/codeInsight/completion/CompletionParameters.getCompletionType must not return null");
        }
        return completionType;
    }

    public int getOffset() {
        return this.myOffset;
    }

    public int getInvocationCount() {
        return this.myInvocationCount;
    }
}

