/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight;

import com.intellij.codeInsight.ExternalAnnotationsManager;
import com.intellij.psi.HierarchicalMethodSignature;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.ArrayUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationUtil {
    public static final String NULLABLE = "org.jetbrains.annotations.Nullable";
    public static final String NOT_NULL = "org.jetbrains.annotations.NotNull";
    @NonNls
    public static final String NOT_NULL_SIMPLE_NAME = "NotNull";
    @NonNls
    public static final String NULLABLE_SIMPLE_NAME = "Nullable";
    public static final String NON_NLS = "org.jetbrains.annotations.NonNls";
    public static final String NLS = "org.jetbrains.annotations.Nls";
    public static final String PROPERTY_KEY = "org.jetbrains.annotations.PropertyKey";
    @NonNls
    public static final String PROPERTY_KEY_RESOURCE_BUNDLE_PARAMETER = "resourceBundle";
    @NonNls
    public static final String NON_NLS_SIMPLE_NAME = "NonNls";
    @NonNls
    public static final String PROPERTY_KEY_SIMPLE_NAME = "PropertyKey";
    public static final String TEST_ONLY = "org.jetbrains.annotations.TestOnly";
    @NonNls
    public static final String TEST_ONLY_SIMPLE_NAME = "TestOnly";
    public static final String LANGUAGE = "org.intellij.lang.annotations.Language";
    public static final Set<String> ALL_ANNOTATIONS;
    @NonNls
    private static final String[] SIMPLE_NAMES;
    public static final String TARGET_ANNOTATION_FQ_NAME = "java.lang.annotation.Target";

    public static boolean isNullable(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isNullable must not be null");
        }
        return !AnnotationUtil.isNotNull(owner) && AnnotationUtil.isAnnotated(owner, NULLABLE, true);
    }

    public static boolean isNotNull(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isNotNull must not be null");
        }
        return AnnotationUtil.isAnnotated(owner, NOT_NULL, true);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.findAnnotation must not be null");
        }
        return AnnotationUtil.findAnnotation(listOwner, false, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, boolean skipExternal, String ... annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException("Argument 2 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.findAnnotation must not be null");
        }
        if (annotationNames.length == 0) {
            return null;
        }
        Set<String> set = annotationNames.length == 1 ? Collections.singleton(annotationNames[0]) : new HashSet<String>(Arrays.asList(annotationNames));
        return AnnotationUtil.findAnnotation(listOwner, set, skipExternal);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(PsiModifierListOwner listOwner, @NotNull Set<String> annotationNames) {
        if (annotationNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.findAnnotation must not be null");
        }
        return AnnotationUtil.findAnnotation(listOwner, annotationNames);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Collection<String> annotationNames) {
        return AnnotationUtil.findAnnotation(listOwner, annotationNames, false);
    }

    @Nullable
    public static PsiAnnotation findAnnotation(@Nullable PsiModifierListOwner listOwner, Collection<String> annotationNames, boolean skipExternal) {
        PsiAnnotation[] allAnnotations;
        if (listOwner == null) {
            return null;
        }
        PsiModifierList list = listOwner.getModifierList();
        if (list == null) {
            return null;
        }
        for (PsiAnnotation annotation : allAnnotations = list.getAnnotations()) {
            String qualifiedName = annotation.getQualifiedName();
            if (!annotationNames.contains(qualifiedName)) continue;
            return annotation;
        }
        if (!skipExternal) {
            ExternalAnnotationsManager annotationsManager = ExternalAnnotationsManager.getInstance(listOwner.getProject());
            for (String annotationName : annotationNames) {
                PsiAnnotation annotation;
                annotation = annotationsManager.findExternalAnnotation(listOwner, annotationName);
                if (annotation == null) continue;
                return annotation;
            }
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public static PsiAnnotation[] findAnnotations(PsiModifierListOwner modifierListOwner, @NotNull Collection<String> annotationNames) {
        PsiAnnotation[] psiAnnotationArray;
        if (annotationNames == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.findAnnotations must not be null");
        }
        if (modifierListOwner == null) {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
            if (PsiAnnotation.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
            return psiAnnotationArray;
        }
        PsiModifierList modifierList = modifierListOwner.getModifierList();
        if (modifierList == null) {
            psiAnnotationArray = PsiAnnotation.EMPTY_ARRAY;
            if (PsiAnnotation.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
            return psiAnnotationArray;
        }
        PsiAnnotation[] annotations = modifierList.getAnnotations();
        ArrayList<PsiAnnotation> result = null;
        for (PsiAnnotation psiAnnotation : annotations) {
            if (!annotationNames.contains(psiAnnotation.getQualifiedName())) continue;
            if (result == null) {
                result = new ArrayList<PsiAnnotation>();
            }
            result.add(psiAnnotation);
        }
        psiAnnotationArray = result == null ? PsiAnnotation.EMPTY_ARRAY : result.toArray(new PsiAnnotation[result.size()]);
        if (psiAnnotationArray != null) return psiAnnotationArray;
        throw new IllegalStateException("@NotNull method com/intellij/codeInsight/AnnotationUtil.findAnnotations must not return null");
    }

    @Nullable
    public static PsiAnnotation findAnnotationInHierarchy(PsiModifierListOwner listOwner, Set<String> annotationNames) {
        PsiAnnotation directAnnotation = AnnotationUtil.findAnnotation(listOwner, annotationNames);
        if (directAnnotation != null) {
            return directAnnotation;
        }
        if (listOwner instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)listOwner;
            PsiClass aClass = method.getContainingClass();
            if (aClass == null) {
                return null;
            }
            HierarchicalMethodSignature methodSignature = method.getHierarchicalMethodSignature();
            return AnnotationUtil.findAnnotationInHierarchy(methodSignature, annotationNames, method, null);
        }
        if (listOwner instanceof PsiClass) {
            return AnnotationUtil.findAnnotationInHierarchy((PsiClass)listOwner, annotationNames, null);
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(@NotNull PsiClass psiClass, Set<String> annotationNames, Set<PsiClass> processed) {
        PsiClass[] superClasses;
        if (psiClass == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.findAnnotationInHierarchy must not be null");
        }
        for (PsiClass superClass : superClasses = psiClass.getSupers()) {
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add((PsiClass)superClass)) {
                return null;
            }
            PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)superClass, annotationNames);
            if (annotation != null) {
                return annotation;
            }
            PsiAnnotation annotationInHierarchy = AnnotationUtil.findAnnotationInHierarchy(superClass, annotationNames, (Set<PsiClass>)processed);
            if (annotationInHierarchy == null) continue;
            return annotationInHierarchy;
        }
        return null;
    }

    @Nullable
    private static PsiAnnotation findAnnotationInHierarchy(HierarchicalMethodSignature signature, Set<String> annotationNames, PsiElement place, Set<PsiMethod> processed) {
        List<HierarchicalMethodSignature> superSignatures = signature.getSuperSignatures();
        PsiResolveHelper resolveHelper = JavaPsiFacade.getInstance(place.getProject()).getResolveHelper();
        for (HierarchicalMethodSignature superSignature : superSignatures) {
            PsiMethod superMethod = superSignature.getMethod();
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add((PsiMethod)superMethod) || !resolveHelper.isAccessible(superMethod, place, null)) continue;
            PsiAnnotation direct = AnnotationUtil.findAnnotation((PsiModifierListOwner)superMethod, annotationNames);
            if (direct != null) {
                return direct;
            }
            PsiAnnotation superResult = AnnotationUtil.findAnnotationInHierarchy(superSignature, annotationNames, place, (Set<PsiMethod>)processed);
            if (superResult == null) continue;
            return superResult;
        }
        return null;
    }

    public static boolean isAnnotated(PsiModifierListOwner listOwner, Collection<String> annotations) {
        for (String annotation : annotations) {
            if (!AnnotationUtil.isAnnotated(listOwner, annotation, false)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isAnnotated must not be null");
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, false, null);
    }

    public static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal) {
        if (listOwner == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isAnnotated must not be null");
        }
        return AnnotationUtil.isAnnotated(listOwner, annotationFQN, checkHierarchy, skipExternal, null);
    }

    private static boolean isAnnotated(@NotNull PsiModifierListOwner listOwner, @NonNls String annotationFQN, boolean checkHierarchy, boolean skipExternal, Set<PsiMember> processed) {
        block11: {
            PsiClass[] superClasses;
            block12: {
                PsiMethod[] superMethods;
                if (listOwner == null) {
                    throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/codeInsight/AnnotationUtil.isAnnotated must not be null");
                }
                if (!listOwner.isValid()) {
                    return false;
                }
                PsiModifierList modifierList = listOwner.getModifierList();
                if (modifierList == null) {
                    return false;
                }
                PsiAnnotation annotation = modifierList.findAnnotation(annotationFQN);
                if (annotation != null) {
                    return true;
                }
                if (!skipExternal && ExternalAnnotationsManager.getInstance(listOwner.getProject()).findExternalAnnotation(listOwner, annotationFQN) != null) {
                    return true;
                }
                if (!checkHierarchy) break block11;
                if (!(listOwner instanceof PsiMethod)) break block12;
                PsiMethod method = (PsiMethod)listOwner;
                if (processed == null) {
                    processed = new THashSet();
                }
                if (!processed.add((PsiMember)method)) {
                    return false;
                }
                for (PsiMethod superMethod : superMethods = method.findSuperMethods()) {
                    if (!AnnotationUtil.isAnnotated(superMethod, annotationFQN, checkHierarchy, skipExternal, (Set<PsiMember>)processed)) continue;
                    return true;
                }
                break block11;
            }
            if (!(listOwner instanceof PsiClass)) break block11;
            PsiClass clazz = (PsiClass)listOwner;
            if (processed == null) {
                processed = new THashSet();
            }
            if (!processed.add(clazz)) {
                return false;
            }
            for (PsiClass superClass : superClasses = clazz.getSupers()) {
                if (!AnnotationUtil.isAnnotated(superClass, annotationFQN, checkHierarchy, skipExternal, (Set<PsiMember>)processed)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isAnnotatingApplicable(PsiElement elt) {
        return PsiUtil.isLanguageLevel5OrHigher(elt) && JavaPsiFacade.getInstance(elt.getProject()).findClass(NULLABLE, elt.getResolveScope()) != null;
    }

    public static boolean isJetbrainsAnnotation(@NonNls String simpleName) {
        return ArrayUtil.find((Object[])SIMPLE_NAMES, (Object)simpleName) != -1;
    }

    public static boolean checkAnnotatedUsingPatterns(PsiModifierListOwner owner, Collection<String> annotations) {
        PsiModifierList modList;
        ArrayList<String> fqns = null;
        if (owner == null || (modList = owner.getModifierList()) == null) {
            return false;
        }
        for (String fqn : annotations) {
            if (!fqn.endsWith("*") && AnnotationUtil.isAnnotated(owner, fqn, false)) {
                return true;
            }
            if (fqns == null) {
                PsiAnnotation[] annos;
                fqns = new ArrayList<String>();
                for (PsiAnnotation anno : annos = modList.getAnnotations()) {
                    String qName = anno.getQualifiedName();
                    if (qName == null) continue;
                    fqns.add(qName);
                }
                if (fqns.isEmpty()) {
                    return false;
                }
            }
            fqn = fqn.substring(0, fqn.length() - 2);
            for (String annoFQN : fqns) {
                if (!annoFQN.startsWith(fqn)) continue;
                return true;
            }
        }
        return false;
    }

    static {
        SIMPLE_NAMES = new String[]{NOT_NULL_SIMPLE_NAME, NULLABLE_SIMPLE_NAME, NON_NLS_SIMPLE_NAME, PROPERTY_KEY_SIMPLE_NAME, TEST_ONLY_SIMPLE_NAME, "Language", "Identifier", "Pattern", "PrintFormat", "RegExp", "Subst"};
        ALL_ANNOTATIONS = new HashSet<String>(2);
        ALL_ANNOTATIONS.add(NULLABLE);
        ALL_ANNOTATIONS.add(NOT_NULL);
    }
}

