/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.psi.impl.reference.providers;

import com.intellij.lang.ant.psi.AntStructuredElement;
import com.intellij.lang.ant.psi.impl.reference.AntRefIdReference;
import com.intellij.lang.ant.psi.introspection.AntAttributeType;
import com.intellij.lang.ant.psi.introspection.AntTypeDefinition;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.util.ProcessingContext;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class AntRefIdReferenceProvider
extends PsiReferenceProvider {
    /*
     * Enabled aggressive block sorting
     */
    @NotNull
    public PsiReference[] getReferencesByElement(@NotNull PsiElement element, @NotNull ProcessingContext context) {
        PsiReference[] psiReferenceArray;
        if (element == null) {
            throw new IllegalArgumentException("Argument 0 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntRefIdReferenceProvider.getReferencesByElement must not be null");
        }
        if (context == null) {
            throw new IllegalArgumentException("Argument 1 for @NotNull parameter of com/intellij/lang/ant/psi/impl/reference/providers/AntRefIdReferenceProvider.getReferencesByElement must not be null");
        }
        if (!(element instanceof AntStructuredElement)) {
            psiReferenceArray = PsiReference.EMPTY_ARRAY;
            if (PsiReference.EMPTY_ARRAY == null) throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntRefIdReferenceProvider.getReferencesByElement must not return null");
            return psiReferenceArray;
        }
        AntStructuredElement se = (AntStructuredElement)element;
        ArrayList<AntRefIdReference> refs = new ArrayList<AntRefIdReference>();
        for (XmlAttribute attr : se.getSourceElement().getAttributes()) {
            XmlAttributeValue valueElement;
            if (!AntRefIdReferenceProvider.isRefAttribute(se, attr.getName()) || (valueElement = attr.getValueElement()) == null) continue;
            int offsetInPosition = valueElement.getTextRange().getStartOffset() - se.getTextRange().getStartOffset() + 1;
            String attrValue = attr.getValue();
            if (attrValue == null || attrValue.indexOf("@{") >= 0) continue;
            refs.add(new AntRefIdReference(se, attrValue, new TextRange(offsetInPosition, offsetInPosition + attrValue.length()), attr));
        }
        psiReferenceArray = refs.toArray(new PsiReference[refs.size()]);
        if (psiReferenceArray != null) return psiReferenceArray;
        throw new IllegalStateException("@NotNull method com/intellij/lang/ant/psi/impl/reference/providers/AntRefIdReferenceProvider.getReferencesByElement must not return null");
    }

    private static boolean isRefAttribute(AntStructuredElement element, @NonNls String attribName) {
        if ("refid".equals(attribName)) {
            return true;
        }
        AntTypeDefinition typeDef = element.getTypeDefinition();
        return typeDef != null && AntAttributeType.ID_REFERENCE == typeDef.getAttributeType(attribName);
    }
}

